/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.api.item.GearArmor;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.compat.caelus.CaelusCompat;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.gear.util.TraitHelper;

public class GearElytraItem
extends ElytraItem
implements GearArmor {
    private static final Supplier<Collection<PartType>> REQUIRED_PARTS = Suppliers.memoize(() -> ImmutableSet.of((Object)((PartType)PartTypes.MAIN.get()), (Object)((PartType)PartTypes.BINDING.get())));
    private final Supplier<GearType> gearType;

    public GearElytraItem(Supplier<GearType> gearType) {
        super(new Item.Properties().stacksTo(1));
        this.gearType = gearType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public boolean isValidSlot(String slot) {
        return EquipmentSlot.CHEST.getName().equalsIgnoreCase(slot) || "back".equalsIgnoreCase(slot);
    }

    @Override
    public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS.get();
    }

    @Override
    public boolean supportsPart(ItemStack gear, PartInstance part) {
        if (!part.isValid()) {
            return false;
        }
        PartType type = part.getType();
        boolean canAdd = part.get().canAddToGear(gear, part);
        boolean supported = this.requiresPartOfType(part.getType()) && canAdd || canAdd;
        return type == PartTypes.MAIN.get() && supported || type == PartTypes.LINING.get() || supported;
    }

    @Override
    public float getRepairModifier(ItemStack stack) {
        return this.getGearType().armorDurabilityMultiplier();
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public int getMaxDamage(ItemStack stack) {
        float durability = GearData.getProperties(stack).getNumber(this.getDurabilityStat());
        return (int)(this.getGearType().armorDurabilityMultiplier() * durability);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return;
        }
        if (!Config.Common.isLoaded() || !((Boolean)Config.Common.gearBreaksPermanently.get()).booleanValue()) {
            damage = Mth.clamp((int)damage, (int)0, (int)this.getMaxDamage(stack));
        }
        super.setDamage(stack, damage);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, item -> {
            GearHelper.onBroken(stack, entity instanceof Player ? (Player)entity : null, this.getEquipmentSlot(stack));
            onBroken.accept((Item)item);
        });
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return TraitHelper.hasTrait(stack, Const.Traits.BRILLIANT);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        this.addAttributes(stack, builder, true);
        return builder.build();
    }

    public void addAttributes(ItemStack stack, ItemAttributeModifiers.Builder builder, boolean includeArmor) {
        if (GearHelper.isBroken(stack)) {
            return;
        }
        float armor = GearData.getProperties(stack).getNumber(GearProperties.ARMOR);
        if (armor > 0.0f && includeArmor) {
            ResourceLocation id = ResourceLocation.withDefaultNamespace((String)"armor.body");
            builder.add(Attributes.ARMOR, new AttributeModifier(id, (double)armor, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.BODY);
        }
        GearHelper.addAttributeModifiers(stack, builder, false);
        CaelusCompat.tryAddFlightAttribute(builder);
    }

    public Component getName(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        if (!ModList.get().isLoaded("caelus")) {
            tooltip.add((Component)TextUtil.misc("caelusNotInstalled", new Object[0]).withStyle(ChatFormatting.RED));
        }
        GearClientHelper.addInformation(stack, tooltipContext, tooltip, flagIn);
    }

    public int getBarWidth(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

