/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.GearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.blueprint.AbstractBlueprintItem;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;
import net.silentchaos512.lib.util.MathUtils;
import net.silentchaos512.lib.util.NameUtils;

public class GearBlueprintItem
extends AbstractBlueprintItem {
    private final Supplier<GearType> gearType;
    private TagKey<Item> itemTag;

    public GearBlueprintItem(Supplier<GearType> gearType, BlueprintType type, Item.Properties properties) {
        super(properties, type);
        this.gearType = gearType;
    }

    @Override
    public PartType getPartType(ItemStack stack) {
        return (PartType)PartTypes.MAIN.get();
    }

    public GearType gearType() {
        return this.gearType.get();
    }

    @Override
    public GearType getGearType(ItemStack stack) {
        return this.gearType.get();
    }

    @Override
    public TagKey<Item> getItemTag() {
        if (this.itemTag == null) {
            ResourceLocation id = NameUtils.fromItem((ItemLike)this);
            String itemClass = Objects.requireNonNull(SgRegistries.GEAR_TYPE.getKey((Object)this.gearType())).getPath();
            this.itemTag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("blueprints/" + itemClass)));
        }
        return this.itemTag;
    }

    @Override
    protected Component getCraftedName(ItemStack stack) {
        ResourceLocation id = NameUtils.fromItem((ItemLike)this);
        String itemClass = Objects.requireNonNull(SgRegistries.GEAR_TYPE.getKey((Object)this.gearType())).getPath();
        return Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)itemClass)));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flags) {
        String itemClass = Objects.requireNonNull(SgRegistries.GEAR_TYPE.getKey((Object)this.gearType())).getPath();
        if (!this.gearType().isArmor()) {
            String key = "item." + NameUtils.fromItem((ItemStack)stack).getNamespace() + ".blueprint." + itemClass + ".desc";
            tooltip.add((Component)Component.translatable((String)key).withStyle(ChatFormatting.ITALIC));
        }
        if (!MathUtils.floatsEqual((float)this.gearType().armorDurabilityMultiplier(), (float)1.0f)) {
            tooltip.add((Component)TextUtil.translate("item", "blueprint.armorDurability", Float.valueOf(this.gearType().armorDurabilityMultiplier())).withStyle(ChatFormatting.ITALIC));
        }
        super.appendHoverText(stack, tooltipContext, tooltip, flags);
        if (this.isDisabled()) {
            tooltip.add((Component)Component.translatable((String)"item.silentgear.blueprint.disabled").withStyle(ChatFormatting.DARK_RED));
        } else if (this.isSingleUse()) {
            tooltip.add((Component)Component.translatable((String)"item.silentgear.blueprint.singleUse").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.silentgear.blueprint.multiUse").withStyle(ChatFormatting.GREEN));
        }
        this.appendSupportedTypesText(tooltip);
    }

    private void appendSupportedTypesText(Collection<Component> list) {
        if (KeyTracker.isDisplayStatsDown()) {
            GearItem item = GearType.getItem(this.gearType());
            if (item != null) {
                TextListBuilder builder = new TextListBuilder();
                ItemStack gear = new ItemStack((ItemLike)item);
                for (PartType type : SgRegistries.PART_TYPE) {
                    List<GearPart> partsOfType;
                    if (type == PartTypes.MAIN.get() || (partsOfType = SgRegistries.PART.getPartsOfType(type)).isEmpty() || !item.supportsPart(gear, PartInstance.of(partsOfType.getFirst()))) continue;
                    builder.add((Component)type.getDisplayName());
                }
                List<Component> lines = builder.build();
                if (!lines.isEmpty()) {
                    list.add((Component)TextUtil.withColor(TextUtil.misc("supportedPartTypes", new Object[0]), Color.GOLD));
                    list.addAll(lines);
                }
            }
        } else {
            list.add((Component)TextUtil.withColor(TextUtil.misc("supportedPartTypes", new Object[0]), Color.GOLD).append(" ").append((Component)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_STATS), ChatFormatting.GRAY)));
        }
    }
}

