/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitConditionSerializer;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.gear.trait.Trait;
import net.silentchaos512.gear.util.TextUtil;

public record MaterialRatioTraitCondition(float requiredRatio) implements ITraitCondition
{
    public static final MapCodec<MaterialRatioTraitCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("ratio").forGetter(c -> Float.valueOf(c.requiredRatio))).apply((Applicative)instance, MaterialRatioTraitCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MaterialRatioTraitCondition> STREAM_CODEC = StreamCodec.of((buf, con) -> ByteBufCodecs.FLOAT.encode(buf, (Object)Float.valueOf(con.requiredRatio)), buf -> new MaterialRatioTraitCondition(((Float)ByteBufCodecs.FLOAT.decode(buf)).floatValue()));
    public static final TraitConditionSerializer<MaterialRatioTraitCondition> SERIALIZER = new TraitConditionSerializer<MaterialRatioTraitCondition>(CODEC, STREAM_CODEC);

    @Override
    public TraitConditionSerializer<?> serializer() {
        return SERIALIZER;
    }

    @Override
    public boolean matches(Trait trait, PartGearKey key, List<? extends GearComponentInstance<?>> components) {
        int count = 0;
        block0: for (GearComponentInstance<?> comp : components) {
            Collection<TraitInstance> traits = comp.getTraits(key);
            for (TraitInstance inst : traits) {
                if (inst.getTrait() != trait) continue;
                ++count;
                continue block0;
            }
        }
        float ratio = (float)count / (float)components.size();
        return ratio >= this.requiredRatio;
    }

    @Override
    public MutableComponent getDisplayText() {
        return TextUtil.translate("trait.condition", "material_ratio", Math.round(this.requiredRatio * 100.0f));
    }
}

