/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material.modifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.property.NumberPropertyValue;
import net.silentchaos512.gear.api.util.ChargedProperties;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.modifier.ChargedMaterialModifier;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.MaterialModifiers;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;

public class StarchargedMaterialModifier
extends ChargedMaterialModifier {
    public StarchargedMaterialModifier(int level) {
        super(level);
    }

    @Override
    public IMaterialModifierType<?> getType() {
        return (IMaterialModifierType)MaterialModifiers.STARCHARGED.get();
    }

    @Override
    public <T, V extends GearPropertyValue<T>> Collection<V> modifyStats(MaterialInstance material, PartType partType, PropertyKey<T, V> key, Collection<V> modifiers) {
        ArrayList<GearPropertyValue> ret = new ArrayList<GearPropertyValue>();
        if (key.property() == GearProperties.CHARGING_VALUE.get()) {
            return ret;
        }
        for (GearPropertyValue mod : modifiers) {
            GearPropertyValue newMod = StarchargedMaterialModifier.modifyStat(key, mod, this.getChargedProperties(material));
            ret.add(newMod != null ? newMod : mod);
        }
        return ret;
    }

    @Override
    public void appendTooltip(List<Component> tooltip) {
        MutableComponent text = this.getNameWithLevel();
        tooltip.add((Component)TextUtil.withColor(text, Color.AQUAMARINE));
    }

    @Override
    public MutableComponent modifyMaterialName(MutableComponent name) {
        return this.getNameWithLevel().append(" ").append((Component)name);
    }

    private MutableComponent getNameWithLevel() {
        MutableComponent text = TextUtil.translate("materialModifier", "starcharged");
        text.append(" ").append((Component)Component.translatable((String)("enchantment.level." + this.level)));
        return text;
    }

    @Nullable
    private static GearPropertyValue<?> modifyStat(PropertyKey<?, ?> key, GearPropertyValue<?> mod, ChargedProperties charge) {
        NumberPropertyValue numberPropertyValue;
        if (key.property() == GearProperties.CHARGING_VALUE.get()) {
            return null;
        }
        if (mod instanceof NumberPropertyValue && StarchargedMaterialModifier.isSupportedModifierOp(numberPropertyValue = (NumberPropertyValue)mod)) {
            PropertyKey<Float, NumberPropertyValue> numberPropertyKey = key;
            float modifiedStatValue = (float)StarchargedMaterialModifier.getModifiedStatValue(numberPropertyKey, numberPropertyValue, charge);
            return new NumberPropertyValue(modifiedStatValue, numberPropertyValue.operation());
        }
        return null;
    }

    private static double getModifiedStatValue(PropertyKey<Float, NumberPropertyValue> key, NumberPropertyValue mod, ChargedProperties charge) {
        if (key.property() == GearProperties.DURABILITY.get()) {
            return (double)((Float)mod.value()).floatValue() * Math.pow(1.25, charge.getChargeValue());
        }
        if (key.property() == GearProperties.ARMOR_DURABILITY.get()) {
            return (double)((Float)mod.value()).floatValue() * Math.pow(1.1, charge.getChargeValue());
        }
        if (key.property() == GearProperties.ENCHANTMENT_VALUE.get()) {
            return (double)((Float)mod.value()).floatValue() * Math.pow(1.1, charge.getChargeValue());
        }
        if (key.property() == GearProperties.HARVEST_SPEED.get()) {
            return (double)((Float)mod.value()).floatValue() + 1.5 * (double)charge.chargeLevel() * (double)charge.getChargeValue();
        }
        if (key.property() == GearProperties.ATTACK_DAMAGE.get()) {
            return ((Float)mod.value()).floatValue() + charge.getChargeValue();
        }
        if (key.property() == GearProperties.MAGIC_DAMAGE.get()) {
            return ((Float)mod.value()).floatValue() + charge.getChargeValue();
        }
        if (key.property() == GearProperties.RANGED_DAMAGE.get()) {
            return (double)((Float)mod.value()).floatValue() + (double)charge.getChargeValue() / 2.0;
        }
        if (key.property() == GearProperties.ARMOR.get()) {
            return (double)((Float)mod.value()).floatValue() + (double)charge.getChargeValue() * 2.0;
        }
        if (key.property() == GearProperties.ARMOR_TOUGHNESS.get()) {
            return (double)((Float)mod.value()).floatValue() + (double)charge.getChargeValue() * 2.0;
        }
        if (key.property() == GearProperties.MAGIC_ARMOR.get()) {
            return (double)((Float)mod.value()).floatValue() + (double)charge.getChargeValue() * 2.0;
        }
        return ((Float)mod.value()).floatValue();
    }

    private static boolean isSupportedModifierOp(NumberPropertyValue mod) {
        return mod.operation() == NumberProperty.Operation.AVERAGE || mod.operation() == NumberProperty.Operation.MAX || mod.operation() == NumberProperty.Operation.ADD;
    }
}

