/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.material.MaterialCraftingData;
import net.silentchaos512.gear.api.material.MaterialDisplayData;
import net.silentchaos512.gear.api.material.TextureType;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.property.NumberPropertyValue;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.lib.util.Color;

public abstract class AbstractMaterial
implements Material {
    String packName = "UNKNOWN PACK";
    protected final DataResource<Material> parent;
    protected final MaterialCraftingData crafting;
    protected final MaterialDisplayData display;
    protected final Map<PartType, GearPropertyMap> properties = new LinkedHashMap<PartType, GearPropertyMap>();

    protected AbstractMaterial(DataResource<Material> parent, MaterialCraftingData crafting, MaterialDisplayData display, Map<PartType, GearPropertyMap> properties) {
        this.parent = parent;
        this.crafting = crafting;
        this.display = display;
        this.properties.putAll(properties);
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    @Override
    @Nullable
    public Material getParent() {
        return this.parent.getNullable();
    }

    @Override
    public Collection<IMaterialCategory> getCategories(MaterialInstance material) {
        List<IMaterialCategory> categories = this.crafting.categories();
        if (categories.isEmpty() && this.getParent() != null) {
            return this.getParent().getCategories(material);
        }
        return new HashSet<IMaterialCategory>(categories);
    }

    @Override
    public boolean isInCategory(IMaterialCategory category) {
        return this.crafting.categories().contains(category);
    }

    @Override
    public Ingredient getIngredient() {
        return this.crafting.craftingItem();
    }

    @Override
    public Optional<Ingredient> getPartSubstitute(PartType partType) {
        return Optional.ofNullable(this.crafting.partSubstitutes().get(partType));
    }

    @Override
    public boolean hasPartSubstitutes() {
        return !this.crafting.partSubstitutes().isEmpty();
    }

    @Override
    public boolean canSalvage() {
        return this.crafting.canSalvage();
    }

    @Override
    public MaterialInstance onSalvage(MaterialInstance material) {
        return AbstractMaterial.removeEnhancements(material);
    }

    public static MaterialInstance removeEnhancements(MaterialInstance material) {
        ItemStack stack = material.getItem().copy();
        for (IMaterialModifierType modifierType : SgRegistries.MATERIAL_MODIFIER_TYPE) {
            modifierType.removeModifier(stack);
        }
        stack.set(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        Material iMaterial = material.get();
        if (iMaterial != null) {
            return MaterialInstance.of(iMaterial, stack);
        }
        return material;
    }

    @Override
    public Set<PartType> getPartTypes(MaterialInstance material) {
        return Sets.union(this.properties.keySet(), this.getParentOptional().map(m -> new LinkedHashSet<PartType>(m.getPartTypes(material))).orElse(Collections.emptySet()));
    }

    @Override
    public boolean isAllowedInPart(MaterialInstance material, PartType partType) {
        return this.getPartTypes(material).contains(partType);
    }

    @Override
    public <T, V extends GearPropertyValue<T>> Collection<V> getPropertyModifiers(MaterialInstance instance, PartType partType, PropertyKey<T, V> key) {
        ArrayList<V> ret = new ArrayList<V>(this.properties.getOrDefault(partType, GearPropertyMap.EMPTY).getValues(key));
        if (ret.isEmpty() && this.getParent() != null) {
            ret.addAll(this.getParent().getPropertyModifiers(instance, partType, key));
        }
        return ret;
    }

    @Override
    public Collection<PropertyKey<?, ?>> getPropertyKeys(MaterialInstance material, PartType type) {
        GearPropertyMap map = this.properties.getOrDefault(type, GearPropertyMap.EMPTY);
        if (map.isEmpty() && this.getParent() != null) {
            return this.getParent().getPropertyKeys(material, type);
        }
        return map.keySet();
    }

    @Override
    public boolean isCraftingAllowed(MaterialInstance material, PartType partType, GearType gearType, @Nullable CraftingInput craftingInput) {
        if (this.isGearTypeBlacklisted(gearType) || partType != PartTypes.NONE.get() && !this.isAllowedInPart(material, partType)) {
            return false;
        }
        if (this.properties.containsKey(partType) || partType == PartTypes.NONE.get() || this.getParent() != null && this.getParent().isCraftingAllowed(material, partType, gearType, craftingInput)) {
            if (partType == PartTypes.MAIN.get()) {
                NumberProperty durabilityProperty = gearType.durabilityStat().get();
                PropertyKey<Float, NumberPropertyValue> durabilityKey = PropertyKey.of(durabilityProperty, gearType);
                return !this.getPropertyModifiers(material, partType, durabilityKey).isEmpty() && this.getPropertyUnclamped(material, partType, durabilityKey).floatValue() > 0.0f;
            }
            return true;
        }
        return false;
    }

    private boolean isGearTypeBlacklisted(GearType gearType) {
        for (GearType gt : this.crafting.gearTypeBlacklist()) {
            if (!gearType.matches(gt)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Component getDisplayName(@Nullable MaterialInstance material, PartType type) {
        return this.display.name().copy();
    }

    @Override
    public Component getDisplayNamePrefix(PartType partType) {
        return this.display.namePrefix().copy();
    }

    @Override
    public TextureType getMainTextureType(MaterialInstance material) {
        return this.display.mainTextureType();
    }

    @Override
    public int getColor(MaterialInstance material, PartType partType, GearType gearType) {
        return this.display.color().getColor();
    }

    @Override
    public int getNameColor(MaterialInstance material, PartType partType, GearType gearType) {
        int color = this.getColor(material, partType, gearType);
        return Color.blend((int)color, (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
    }

    public String toString() {
        return "AbstractMaterial{id=" + String.valueOf(SgRegistries.MATERIAL.getKey(this)) + "}";
    }
}

