/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.GearItemSet;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.gear.setup.GearItemSets;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.util.NameUtils;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "silentgear", existingFileHelper);
    }

    @Nonnull
    public String getName() {
        return "Silent Gear - Item Models";
    }

    protected void registerModels() {
        SgBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).forEach(this::blockItemModel);
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/generated"));
        ModelFile.ExistingModelFile itemHandheld = this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/handheld"));
        for (CraftingItems item : CraftingItems.values()) {
            this.builder(item, (ModelFile)itemGenerated, "item/" + item.getName());
        }
        this.builder((ItemLike)SgItems.NETHERWOOD_CHARCOAL, (ModelFile)itemGenerated);
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.SHEET_METAL).parent((ModelFile)itemGenerated)).texture("layer0", "item/sheet_metal")).texture("layer1", "item/sheet_metal_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.ALLOY_INGOT).parent((ModelFile)itemGenerated)).texture("layer0", "item/alloy_ingot")).texture("layer1", "item/alloy_ingot_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.HYBRID_GEM).parent((ModelFile)itemGenerated)).texture("layer0", "item/hybrid_gem")).texture("layer1", "item/hybrid_gem_highlight");
        this.builder((ItemLike)SgItems.MIXED_FABRIC, (ModelFile)itemGenerated, "item/mixed_fabric");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.SUPER_ALLOY).parent((ModelFile)itemGenerated)).texture("layer0", "item/super_alloy")).texture("layer1", "item/super_alloy_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.CUSTOM_INGOT).parent((ModelFile)itemGenerated)).texture("layer0", "item/alloy_ingot")).texture("layer1", "item/alloy_ingot_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.CUSTOM_GEM).parent((ModelFile)itemGenerated)).texture("layer0", "item/hybrid_gem")).texture("layer1", "item/hybrid_gem_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.BLUEPRINT_BOOK).parent((ModelFile)itemGenerated)).texture("layer0", "item/blueprint_book_cover")).texture("layer1", "item/blueprint_book_pages")).texture("layer2", "item/blueprint_book_deco");
        this.builder((ItemLike)SgItems.JEWELER_TOOLS, (ModelFile)itemGenerated, "item/jeweler_tools");
        SgItems.getItems(PartBlueprintItem.class).forEach(arg_0 -> this.lambda$registerModels$0((ModelFile)itemGenerated, arg_0));
        SgItems.getItems(GearBlueprintItem.class).forEach(arg_0 -> this.lambda$registerModels$1((ModelFile)itemGenerated, arg_0));
        this.builder((ItemLike)SgItems.MOD_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.VERY_CRUDE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.CRUDE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.STURDY_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.CRIMSON_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.AZURE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.CRUDE_KNIFE, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.CRUDE_HAMMER, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.COATING_SMITHING_TEMPLATE, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.GUIDE_BOOK, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.BLUEPRINT_PACKAGE, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.FLAX_SEEDS, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.FLUFFY_SEEDS, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.GOLDEN_NETHER_BANANA, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.NETHER_BANANA, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.PEBBLE, (ModelFile)itemGenerated);
        this.tempGearStandardTool(GearItemSets.SWORD, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.KATANA, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.MACHETE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.SPEAR, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.TRIDENT, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.MACE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.KNIFE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.DAGGER, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.PICKAXE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.SHOVEL, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.AXE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.PAXEL, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.HAMMER, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.EXCAVATOR, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.SAW, (ModelFile)this.getExistingFile(this.modLoc("item/saw_base")));
        this.tempGearStandardTool(GearItemSets.PROSPECTOR_HAMMER, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.HOE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.MATTOCK, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.SICKLE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(GearItemSets.SHEARS, (ModelFile)itemHandheld);
        this.tempGearBow(GearItemSets.FISHING_ROD, (ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/handheld_rod")));
        this.tempGearArrow(GearItemSets.ARROW, (ModelFile)itemGenerated);
        this.tempGearArmor(GearItemSets.HELMET, (ModelFile)itemGenerated);
        this.tempGearArmor(GearItemSets.CHESTPLATE, (ModelFile)itemGenerated);
        this.tempGearArmor(GearItemSets.LEGGINGS, (ModelFile)itemGenerated);
        this.tempGearArmor(GearItemSets.BOOTS, (ModelFile)itemGenerated);
        this.tempGearElytra(GearItemSets.ELYTRA, (ModelFile)itemGenerated);
        this.tempGearCurio(GearItemSets.RING, (ModelFile)itemGenerated);
        this.tempGearCurio(GearItemSets.BRACELET, (ModelFile)itemGenerated);
        this.tempGearCurio(GearItemSets.NECKLACE, (ModelFile)itemGenerated);
        this.tempMainPart(GearItemSets.SWORD);
        this.tempMainPart(GearItemSets.KATANA);
        this.tempMainPart(GearItemSets.MACHETE);
        this.tempMainPart(GearItemSets.SPEAR);
        this.tempMainPart(GearItemSets.TRIDENT);
        this.tempMainPart(GearItemSets.MACE);
        this.tempMainPart(GearItemSets.KNIFE);
        this.tempMainPart(GearItemSets.DAGGER);
        this.tempMainPart(GearItemSets.PICKAXE);
        this.tempMainPart(GearItemSets.SHOVEL);
        this.tempMainPart(GearItemSets.AXE);
        this.tempMainPart(GearItemSets.PAXEL);
        this.tempMainPart(GearItemSets.HAMMER);
        this.tempMainPart(GearItemSets.EXCAVATOR);
        this.tempMainPart(GearItemSets.SAW);
        this.tempMainPart(GearItemSets.HOE);
        this.tempMainPart(GearItemSets.MATTOCK);
        this.tempMainPart(GearItemSets.PROSPECTOR_HAMMER);
        this.tempMainPart(GearItemSets.SICKLE);
        this.tempMainPart(GearItemSets.SHEARS);
        this.tempMainPart(GearItemSets.FISHING_ROD);
        this.tempMainPart(GearItemSets.BOW);
        this.tempMainPart(GearItemSets.CROSSBOW);
        this.tempMainPart(GearItemSets.SLINGSHOT);
        this.tempMainPart(GearItemSets.SHIELD);
        this.tempMainPart(GearItemSets.HELMET);
        this.tempMainPart(GearItemSets.CHESTPLATE);
        this.tempMainPart(GearItemSets.LEGGINGS);
        this.tempMainPart(GearItemSets.BOOTS);
        this.tempMainPart(GearItemSets.ELYTRA);
        this.tempMainPart(GearItemSets.ARROW);
        this.tempMainPart(GearItemSets.RING);
        this.tempMainPart(GearItemSets.BRACELET);
        this.tempMainPart(GearItemSets.NECKLACE);
        this.tempGearPart(SgItems.ROD);
        this.tempGearPart(SgItems.TIP);
        this.tempCoatingPart(SgItems.COATING);
        this.tempGearPart(SgItems.GRIP);
        this.tempGearPart(SgItems.BINDING);
        this.tempGearPart(SgItems.LINING, "item/part/lining_cloth");
        this.tempGearPart(SgItems.CORD);
        this.tempGearPart(SgItems.FLETCHING);
        this.tempGearPart(SgItems.SETTING);
    }

    private String gearTypeName(GearType gearType) {
        return Objects.requireNonNull(SgRegistries.GEAR_TYPE.getKey((Object)gearType)).getPath();
    }

    private String itemNamePath(GearItemSet<?> itemSet) {
        return BuiltInRegistries.ITEM.getKey(itemSet.gearItem()).getPath();
    }

    private String itemNamePath(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    private ItemModelBuilder tempGearStandardTool(GearItemSet<? extends GearItem> item, ModelFile parent) {
        String name = this.gearTypeName(item.type());
        String path = BuiltInRegistries.ITEM.getKey((Object)item.gearItem()).getPath();
        ModelFile.UncheckedModelFile mainModelFile = new ModelFile.UncheckedModelFile(this.modLoc("item/" + path));
        ItemModelBuilder model_lc = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_lc")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_lc");
        ItemModelBuilder model_hc = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_hc")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight");
        ItemModelBuilder model_lc_tip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_lc_tip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_lc")).texture("layer2", "item/blank")).texture("layer3", "item/" + name + "/tip_sharp");
        ItemModelBuilder model_hc_tip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_hc_tip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight")).texture("layer3", "item/" + name + "/tip_sharp");
        ItemModelBuilder model_lc_grip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_lc_grip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_lc")).texture("layer2", "item/blank")).texture("layer3", "item/blank")).texture("layer4", "item/" + name + "/grip_wool");
        ItemModelBuilder model_hc_grip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_hc_grip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight")).texture("layer3", "item/blank")).texture("layer4", "item/" + name + "/grip_wool");
        ItemModelBuilder model_lc_tip_grip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_lc_tip_grip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_lc")).texture("layer2", "item/blank")).texture("layer3", "item/" + name + "/tip_sharp")).texture("layer4", "item/" + name + "/grip_wool");
        ItemModelBuilder model_hc_tip_grip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_hc_tip_grip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight")).texture("layer3", "item/" + name + "/tip_sharp")).texture("layer4", "item/" + name + "/grip_wool");
        ItemModelBuilder mainBuilder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent(parent)).override().predicate(Const.MODEL, 2.0f).model((ModelFile)model_lc).end().override().predicate(Const.MODEL, 3.0f).model((ModelFile)model_hc).end().override().predicate(Const.MODEL, 6.0f).model((ModelFile)model_lc_tip).end().override().predicate(Const.MODEL, 7.0f).model((ModelFile)model_hc_tip).end().override().predicate(Const.MODEL, 10.0f).model((ModelFile)model_lc_grip).end().override().predicate(Const.MODEL, 11.0f).model((ModelFile)model_hc_grip).end().override().predicate(Const.MODEL, 14.0f).model((ModelFile)model_lc_tip_grip).end().override().predicate(Const.MODEL, 15.0f).model((ModelFile)model_hc_tip_grip).end().texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_lc");
        return mainBuilder;
    }

    private ItemModelBuilder tempGear(DeferredItem<? extends GearItem> item, ModelFile parent) {
        String name = this.gearTypeName(((GearItem)((Item)item.get())).getGearType());
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().getPath())).parent(parent)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight");
    }

    private ItemModelBuilder tempGearBow(GearItemSet<? extends GearItem> item, ModelFile parent) {
        String name = this.gearTypeName(item.type());
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.itemNamePath(item))).parent(parent)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight")).texture("layer3", "item/" + name + "/bowstring_string");
    }

    private ItemModelBuilder tempGearCurio(GearItemSet<? extends GearItem> item, ModelFile parent) {
        String name = this.gearTypeName(item.type());
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.itemNamePath(item))).parent(parent)).texture("layer0", "item/" + name + "/main_generic_hc")).texture("layer1", "item/" + name + "/_highlight")).texture("layer2", "item/" + name + "/adornment_generic")).texture("layer3", "item/" + name + "/adornment_highlight");
    }

    private ItemModelBuilder tempGearArmor(GearItemSet<? extends GearItem> item, ModelFile parent) {
        String name = this.gearTypeName(item.type());
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.itemNamePath(item))).parent(parent)).texture("layer0", "item/" + name + "/main_generic_hc")).texture("layer1", "item/" + name + "/_highlight");
    }

    private ItemModelBuilder tempGearElytra(GearItemSet<? extends GearItem> item, ModelFile parent) {
        String name = this.gearTypeName(item.type());
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.itemNamePath(item))).parent(parent)).texture("layer0", "item/" + name + "/main_generic_hc")).texture("layer1", "item/" + name + "/_highlight")).texture("layer2", "item/" + name + "/binding_generic");
    }

    private ItemModelBuilder tempGearArrow(GearItemSet<? extends GearItem> item, ModelFile parent) {
        String name = this.gearTypeName(item.type());
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.itemNamePath(item))).parent(parent)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight")).texture("layer3", "item/" + name + "/fletching_generic");
    }

    private ItemModelBuilder tempMainPart(GearItemSet<? extends GearItem> item) {
        String name = this.gearTypeName(item.type());
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.itemNamePath(item.mainPart()))).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/generated")))).texture("layer0", "item/" + name + "/main_generic_hc")).texture("layer1", "item/" + name + "/_highlight")).texture("layer2", "item/part_marker");
    }

    private ItemModelBuilder tempGearPart(DeferredItem<CompoundPartItem> item) {
        String name = Objects.requireNonNull(SgRegistries.PART_TYPE.getKey((Object)((CompoundPartItem)((Object)item.get())).getPartType())).getPath();
        return this.tempGearPart(item, "item/part/" + name);
    }

    private ItemModelBuilder tempGearPart(DeferredItem<CompoundPartItem> item, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/generated")))).texture("layer0", texture)).texture("layer1", "item/part_marker");
    }

    private ItemModelBuilder tempCoatingPart(DeferredItem<CompoundPartItem> item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/generated")))).texture("layer0", "item/part/coating_material")).texture("layer1", "item/part/coating_jar")).texture("layer2", "item/part_marker");
    }

    private void blockItemModel(Block block) {
        if (block == SgBlocks.FLAX_PLANT.get() || block == SgBlocks.FLUFFY_PLANT.get()) {
            return;
        }
        if (block == SgBlocks.PHANTOM_LIGHT.get()) {
            this.builder((ItemLike)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "item/phantom_light");
        } else if (block == SgBlocks.NETHERWOOD_SAPLING.get() || block == SgBlocks.STONE_TORCH.get()) {
            this.builder((ItemLike)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "block/" + NameUtils.fromBlock((Block)block).getPath());
        } else if (block == SgBlocks.NETHERWOOD_FENCE.get()) {
            this.withExistingParent("netherwood_fence", this.modLoc("block/netherwood_fence_inventory"));
        } else if (block == SgBlocks.NETHERWOOD_DOOR.get()) {
            this.builder((ItemLike)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "item/netherwood_door");
        } else if (block == SgBlocks.NETHERWOOD_TRAPDOOR.get()) {
            this.withExistingParent("netherwood_trapdoor", this.modLoc("block/netherwood_trapdoor_bottom"));
        } else if (block.asItem() != Items.AIR) {
            String name = NameUtils.fromBlock((Block)block).getPath();
            this.withExistingParent(name, this.modLoc("block/" + name));
        }
    }

    private ItemModelBuilder builder(ItemLike item) {
        return (ItemModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).getPath());
    }

    private ItemModelBuilder builder(ItemLike item, ModelFile parent) {
        String name = NameUtils.fromItem((ItemLike)item).getPath();
        return this.builder(item, parent, "item/" + name);
    }

    private ItemModelBuilder builder(ItemLike item, ModelFile parent, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).getPath())).parent(parent)).texture("layer0", texture);
    }

    private /* synthetic */ void lambda$registerModels$1(ModelFile itemGenerated, GearBlueprintItem item) {
        ResourceLocation key = SgRegistries.GEAR_TYPE.getKey((Object)item.gearType());
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)item).parent(itemGenerated)).texture("layer0", "item/" + (item.isSingleUse() ? "template" : "blueprint"))).texture("layer1", "item/blueprint_" + Objects.requireNonNull(key).getPath());
    }

    private /* synthetic */ void lambda$registerModels$0(ModelFile itemGenerated, PartBlueprintItem item) {
        if (item.hasStandardModel()) {
            ResourceLocation key = SgRegistries.PART_TYPE.getKey((Object)item.getPartType());
            ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)item).parent(itemGenerated)).texture("layer0", "item/" + (item.isSingleUse() ? "template" : "blueprint"))).texture("layer1", "item/blueprint_" + Objects.requireNonNull(key).getPath());
        }
    }
}

