/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.data.part.PartBuilder;
import net.silentchaos512.gear.api.data.part.PartsProviderBase;
import net.silentchaos512.gear.api.data.part.UpgradePartBuilder;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.GearTypeMatcher;
import net.silentchaos512.gear.api.part.PartCraftingData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.property.TraitListPropertyValue;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.MainPartItem;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.util.NameUtils;

public final class PartsProvider
extends PartsProviderBase {
    public static Map<GearType, Consumer<PartBuilder>> MAIN_PART_PROPERTIES = ImmutableMap.builder().put((Object)((GearType)GearTypes.ARROW.get()), b -> {}).put((Object)((GearType)GearTypes.AXE.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 5.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.BOOTS.get()), b -> b.numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.BOW.get()), b -> b.numberProperty(GearProperties.RANGED_DAMAGE, 1.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.DRAW_SPEED, 1.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f).numberProperty(GearProperties.ENCHANTMENT_VALUE, -0.45f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.BRACELET.get()), b -> {}).put((Object)((GearType)GearTypes.CHESTPLATE.get()), b -> b.numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.CROSSBOW.get()), b -> b.numberProperty(GearProperties.RANGED_DAMAGE, 2.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.DRAW_SPEED, 1.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f).numberProperty(GearProperties.ENCHANTMENT_VALUE, -0.45f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.DAGGER.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 2.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 2.8f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 2.0f).numberProperty(GearProperties.ATTACK_DAMAGE, -0.5f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.ELYTRA.get()), b -> b.numberProperty(GearProperties.ARMOR, -0.65f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ARMOR, -3.5f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.EXCAVATOR.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 2.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 2.0f).numberProperty(GearProperties.DURABILITY, 1.0f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ENCHANTMENT_VALUE, -0.5f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.HARVEST_SPEED, -0.5f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.FISHING_ROD.get()), b -> b.numberProperty(GearProperties.DURABILITY, -0.5f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.25f).numberProperty(GearProperties.ENCHANTMENT_VALUE, -0.75f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ATTACK_SPEED, 4.0f, NumberProperty.Operation.ADD)).put((Object)((GearType)GearTypes.HAMMER.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 4.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 0.8f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.5f).numberProperty(GearProperties.DURABILITY, 1.0f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ENCHANTMENT_VALUE, -0.5f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.HARVEST_SPEED, -0.5f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.HELMET.get()), b -> b.numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.HOE.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, -1.0f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ATTACK_SPEED, 3.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.KATANA.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 4.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.4f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f).numberProperty(GearProperties.DURABILITY, 0.125f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ENCHANTMENT_VALUE, -0.1f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.KNIFE.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 1.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 2.4f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 2.0f).numberProperty(GearProperties.ATTACK_DAMAGE, -0.5f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.DURABILITY, 0.25f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.LEGGINGS.get()), b -> b.numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.MACE.get()), b -> b.numberProperty(GearProperties.DURABILITY, 1.0f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ATTACK_DAMAGE, 3.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 0.6f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.MACHETE.get()), b -> b.numberProperty(GearProperties.HARVEST_SPEED, 0.4f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ATTACK_DAMAGE, 2.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.8f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.MATTOCK.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 1.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.4f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.25f).numberProperty(GearProperties.DURABILITY, 0.25f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ENCHANTMENT_VALUE, -0.25f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.HARVEST_SPEED, -0.25f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.NECKLACE.get()), b -> {}).put((Object)((GearType)GearTypes.PAXEL.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 3.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.2f).numberProperty(GearProperties.DURABILITY, 0.35f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ENCHANTMENT_VALUE, -0.3f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.HARVEST_SPEED, -0.2f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.PICKAXE.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 1.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.2f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.PROSPECTOR_HAMMER.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 2.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.4f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.5f).numberProperty(GearProperties.DURABILITY, -0.25f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ENCHANTMENT_VALUE, -0.25f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.HARVEST_SPEED, -0.25f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.RING.get()), b -> {}).put((Object)((GearType)GearTypes.SAW.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 2.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.6f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.5f).numberProperty(GearProperties.DURABILITY, 1.0f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ENCHANTMENT_VALUE, -0.5f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.HARVEST_SPEED, -0.75f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.SHEARS.get()), b -> b.numberProperty(GearProperties.DURABILITY, -0.048f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.25f)).put((Object)((GearType)GearTypes.SHIELD.get()), b -> b.numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.SHOVEL.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 1.5f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 2.0f)).put((Object)((GearType)GearTypes.SICKLE.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 1.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 2.2f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.SLINGSHOT.get()), b -> b.numberProperty(GearProperties.RANGED_DAMAGE, 0.5f, NumberProperty.Operation.ADD).numberProperty(GearProperties.DRAW_SPEED, 1.5f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 2.0f).numberProperty(GearProperties.ENCHANTMENT_VALUE, -0.65f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.RANGED_DAMAGE, -0.75f, NumberProperty.Operation.MULTIPLY_BASE)).put((Object)((GearType)GearTypes.SPEAR.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 3.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.3f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.25f).numberProperty(GearProperties.DURABILITY, -0.2f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.ATTACK_REACH, 1.0f, NumberProperty.Operation.ADD)).put((Object)((GearType)GearTypes.SWORD.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 3.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.6f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).put((Object)((GearType)GearTypes.TRIDENT.get()), b -> b.numberProperty(GearProperties.ATTACK_DAMAGE, 4.0f, NumberProperty.Operation.ADD).numberProperty(GearProperties.ATTACK_SPEED, 1.1f, NumberProperty.Operation.ADD).numberProperty(GearProperties.REPAIR_EFFICIENCY, 1.0f)).build();

    public PartsProvider(DataGenerator generator) {
        super(generator, "silentgear");
    }

    @Override
    public Collection<PartBuilder> getParts() {
        ArrayList<PartBuilder> ret = new ArrayList<PartBuilder>();
        ret.add(PartsProvider.part("binding", GearTypes.TOOL, PartTypes.BINDING).crafting((ItemLike)SgItems.BINDING));
        ret.add(PartsProvider.part("coating", GearTypes.ALL, PartTypes.COATING).crafting(new PartCraftingData(Ingredient.of((ItemLike[])new ItemLike[]{SgItems.COATING}), (List<GearType>)ImmutableList.of((Object)((GearType)GearTypes.ELYTRA.get())), true)));
        ret.add(PartsProvider.part("cord", GearTypes.RANGED_WEAPON, PartTypes.CORD).crafting((ItemLike)SgItems.CORD));
        ret.add(PartsProvider.part("fletching", GearTypes.PROJECTILE, PartTypes.FLETCHING).crafting((ItemLike)SgItems.FLETCHING));
        ret.add(PartsProvider.part("grip", GearTypes.TOOL, PartTypes.GRIP).crafting((ItemLike)SgItems.GRIP));
        ret.add(PartsProvider.part("lining", GearTypes.ARMOR, PartTypes.LINING).crafting((ItemLike)SgItems.LINING));
        ret.add(PartsProvider.part("rod", GearTypes.TOOL, PartTypes.ROD).crafting((ItemLike)SgItems.ROD));
        ret.add(PartsProvider.part("setting", GearTypes.CURIO, PartTypes.SETTING).crafting((ItemLike)SgItems.SETTING));
        ret.add(PartsProvider.part("tip", GearTypes.TOOL, PartTypes.TIP).crafting((ItemLike)SgItems.TIP));
        SgItems.getItems(MainPartItem.class).forEach(item -> {
            PartBuilder builder = PartsProvider.part(NameUtils.fromItem((ItemLike)item).getPath(), item::getGearType, item::getPartType);
            builder.crafting((ItemLike)item);
            ret.add(PartsProvider.addMainPartStats(builder));
        });
        ret.add(PartsProvider.upgradePart("misc/spoon", CraftingItems.SPOON_UPGRADE).upgradeGearTypes(((GearType)GearTypes.PICKAXE.get()).getMatcher(false)).numberProperty(GearProperties.DURABILITY, 0.2f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.RARITY, 10.0f, NumberProperty.Operation.ADD).property(GearProperties.TRAITS, TraitListPropertyValue.single(Const.Traits.SPOON, 1)));
        ret.add(PartsProvider.upgradePart("misc/road_maker", CraftingItems.ROAD_MAKER_UPGRADE).upgradeGearTypes(((GearType)GearTypes.EXCAVATOR.get()).getMatcher(false)).numberProperty(GearProperties.DURABILITY, 0.1f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.RARITY, 10.0f, NumberProperty.Operation.ADD).property(GearProperties.TRAITS, TraitListPropertyValue.single(Const.Traits.ROAD_MAKER, 1)));
        ret.add(PartsProvider.upgradePart("misc/wide_plate", CraftingItems.WIDE_PLATE_UPGRADE).upgradeGearTypes(new GearTypeMatcher(false, (GearType)GearTypes.HAMMER.get(), (GearType)GearTypes.EXCAVATOR.get())).numberProperty(GearProperties.DURABILITY, 0.1f, NumberProperty.Operation.MULTIPLY_BASE).numberProperty(GearProperties.RARITY, 10.0f, NumberProperty.Operation.ADD).property(GearProperties.TRAITS, TraitListPropertyValue.single(Const.Traits.WIDEN, 1)));
        ret.add(PartsProvider.upgradePart("misc/red_card", CraftingItems.RED_CARD_UPGRADE).upgradeGearTypes(GearTypeMatcher.ALL).numberProperty(GearProperties.RARITY, -5.0f, NumberProperty.Operation.ADD).property(GearProperties.TRAITS, TraitListPropertyValue.single(Const.Traits.RED_CARD, 1)));
        return ret;
    }

    private static PartBuilder part(String name, Supplier<GearType> gearType, Supplier<PartType> partType) {
        return new PartBuilder(SilentGear.getId(name), gearType, partType).display((Component)Component.translatable((String)("part.silentgear." + name.replace('/', '.'))));
    }

    private static UpgradePartBuilder upgradePart(String name, ItemLike item) {
        return (UpgradePartBuilder)new UpgradePartBuilder(SilentGear.getId(name), (Supplier<GearType>)GearTypes.ALL, (Supplier<PartType>)PartTypes.MISC_UPGRADE).crafting(item).display((Component)Component.translatable((String)("part.silentgear." + name.replace('/', '.'))));
    }

    private static PartBuilder addMainPartStats(PartBuilder builder) {
        Consumer<PartBuilder> consumer = MAIN_PART_PROPERTIES.get(builder.getGearType());
        if (consumer == null) {
            throw new IllegalArgumentException("Properties for " + String.valueOf(builder.getId()) + " are missing!");
        }
        consumer.accept(builder);
        return builder;
    }
}

