/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.salvage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.util.GearData;

public class GearSalvagingRecipe
extends SalvagingRecipe {
    public GearSalvagingRecipe(Ingredient ingredient) {
        super(ingredient, Collections.emptyList());
    }

    @Override
    public List<ItemStack> getPossibleResults(Container inv) {
        ItemStack input = inv.getItem(0);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        PartList parts = GearData.getConstruction(input).parts();
        for (PartInstance part : parts) {
            ret.add(part.getItem());
        }
        return ret;
    }

    @Override
    public List<ItemStack> getPossibleResultsForDisplay() {
        return List.of();
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SgRecipes.SALVAGING_GEAR.get();
    }

    public static class Serializer
    implements RecipeSerializer<GearSalvagingRecipe> {
        public static final MapCodec<GearSalvagingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(r -> r.ingredient)).apply((Applicative)instance, GearSalvagingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GearSalvagingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.ingredient, GearSalvagingRecipe::new);

        public MapCodec<GearSalvagingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GearSalvagingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

