/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.core.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.CoreGearPart;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.gear.PartTypes;

public record GearConstructionData(PartList parts, boolean isExample, int brokenCount, int repairedCount) {
    public static final GearConstructionData EMPTY = new GearConstructionData(PartList.empty(), true, 0, 0);
    public static final Codec<GearConstructionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PartList.CODEC.fieldOf("parts").forGetter(d -> d.parts), (App)Codec.BOOL.fieldOf("example").forGetter(d -> d.isExample), (App)Codec.INT.fieldOf("broken_count").forGetter(d -> d.brokenCount), (App)Codec.INT.fieldOf("repairedCount").forGetter(d -> d.repairedCount)).apply((Applicative)instance, GearConstructionData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GearConstructionData> STREAM_CODEC = StreamCodec.composite(PartList.STREAM_CODEC, d -> d.parts, (StreamCodec)ByteBufCodecs.BOOL, d -> d.isExample, (StreamCodec)ByteBufCodecs.VAR_INT, d -> d.brokenCount, (StreamCodec)ByteBufCodecs.VAR_INT, d -> d.repairedCount, GearConstructionData::new);

    @Nullable
    public PartInstance getPartOfType(Supplier<PartType> type) {
        return this.getPartOfType(type.get());
    }

    @Nullable
    public PartInstance getPartOfType(PartType type) {
        for (PartInstance part : this.parts) {
            if (part.getType() != type) continue;
            return part;
        }
        return null;
    }

    @Nullable
    public PartInstance getPrimaryPart() {
        return this.getPartOfType((Supplier<PartType>)PartTypes.MAIN);
    }

    @Nullable
    public PartInstance getCoatingOrMainPart() {
        PartInstance coating = this.getPartOfType((Supplier<PartType>)PartTypes.COATING);
        return coating != null ? coating : this.getPrimaryPart();
    }

    @Nullable
    public MaterialInstance getMainTextureMaterial() {
        PartInstance part = this.getCoatingOrMainPart();
        if (part != null && part.isValid() && part.get() instanceof CoreGearPart) {
            return CompoundPartItem.getPrimaryMaterial(part.getItem());
        }
        return null;
    }
}

