/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.PlayerUtils;

public final class PropertiesCommand {
    private PropertiesCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgear_properties").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"info").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> PropertiesCommand.runInfo((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))).executes(ctx -> PropertiesCommand.runInfo((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).getPlayerOrException())))).then(Commands.literal((String)"recalculate").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(ctx -> PropertiesCommand.runRecalculate((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))));
    }

    private static int runInfo(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        ItemStack stack = player.getMainHandItem();
        if (!GearHelper.isGear(stack)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)TextUtil.translate("command", "invalidItemType", stack.getHoverName()));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> TextUtil.translate("command", "stats.info.header", player.getName(), stack.getHoverName()).withStyle(ChatFormatting.BOLD), true);
        GearItem item = (GearItem)stack.getItem();
        PartList parts = GearData.getConstruction(stack).parts();
        GearPropertyMap properties = parts.getPropertyModifiersFromParts(item.getGearType());
        for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
            PropertyKey key = PropertyKey.of(property, item.getGearType());
            Collection<GearPropertyValue<?>> mods = properties.get(key);
            if (mods.isEmpty()) continue;
            MutableComponent name = TextUtil.withColor(property.getDisplayName(), property.getGroup().getColor());
            Component modsText = GearPropertyMap.formatTextUnchecked(mods, property, true);
            MutableComponent valueText = TextUtil.withColor(property.formatModifiersWithColorUnchecked(mods, true), ChatFormatting.YELLOW);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> PropertiesCommand.lambda$runInfo$5((Component)name, modsText, (Component)valueText), true);
            for (PartInstance part : parts) {
                Collection partMods = part.getPropertyModifiers(part.getType(), key);
                if (partMods.isEmpty()) continue;
                Component partName = part.getDisplayName(part.getType());
                Component partModsText = GearPropertyMap.formatTextUnchecked(partMods, property, true);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> TextUtil.translate("command", "stats.info.formatPart", partName, partModsText), true);
            }
        }
        return 1;
    }

    private static int runRecalculate(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            for (ItemStack stack : PlayerUtils.getNonEmptyStacks((Player)player)) {
                if (!GearHelper.isGear(stack)) continue;
                GearData.recalculateGearData(stack, (Player)player);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.silentgear.recalculate", (Object[])new Object[]{player.getScoreboardName()}), true);
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$runInfo$5(Component name, Component modsText, Component valueText) {
        return TextUtil.translate("command", "stats.info.format", name, modsText, valueText);
    }
}

