/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.network.payload.server.CommandOutputPayload;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;

public final class MaterialsCommand {
    private static final SuggestionProvider<CommandSourceStack> MATERIAL_ID_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.suggestResource(SgRegistries.MATERIAL.keySet(), (SuggestionsBuilder)builder);
    private static final Pattern FORMAT_CODES = Pattern.compile("\u00a7[0-9a-z]");

    private MaterialsCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.literal((String)"sgear_mats");
        builder.then(Commands.literal((String)"list").executes(MaterialsCommand::runList));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"dump").then(Commands.argument((String)"includeChildren", (ArgumentType)BoolArgumentType.bool()).executes(context -> MaterialsCommand.runDump((CommandContext<CommandSourceStack>)context, (Boolean)context.getArgument("includeChildren", Boolean.class))))).executes(context -> MaterialsCommand.runDump((CommandContext<CommandSourceStack>)context, true)));
        dispatcher.register(builder);
    }

    private static int runList(CommandContext<CommandSourceStack> context) {
        String listStr = SgRegistries.MATERIAL.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)listStr), true);
        return 1;
    }

    private static int runDump(CommandContext<CommandSourceStack> context, boolean includeChildren) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        SilentGear.LOGGER.info("Send material dump packet to client {}", (Object)player.getScoreboardName());
        CommandOutputPayload message = CommandOutputPayload.materials(includeChildren);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runDumpClient(boolean includeChildren) {
        Player player = SilentGear.PROXY.getClientPlayer();
        if (player == null) {
            SilentGear.LOGGER.error("MaterialsCommand#runDumpClient: player is null?");
            return;
        }
        String dirPath = "output/silentgear";
        String fileName = "material_export.tsv";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            player.sendSystemMessage((Component)Component.literal((String)("Could not create directory: " + output.getParent())));
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            StringBuilder builder = new StringBuilder("Pack\tName\tType\tID\tParent\t");
            SgRegistries.GEAR_PROPERTY.forEach(prop -> builder.append(prop.getDisplayName().getString()).append("\t"));
            writer.write(String.valueOf(builder) + "\n");
            ArrayList partTypes = new ArrayList(SgRegistries.PART_TYPE.stream().toList());
            partTypes.sort((o1, o2) -> Comparator.comparing(o -> ((PartType)o).getDisplayName().getString()).compare(o1, o2));
            for (PartType partType : partTypes) {
                for (Material material : SgRegistries.MATERIAL) {
                    MaterialInstance inst;
                    if (!includeChildren && !MaterialsCommand.getParentId(material).isEmpty() || !material.isAllowedInPart(inst = MaterialInstance.of(material), partType)) continue;
                    writer.write(MaterialsCommand.makeTsvLine(inst, partType) + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            MutableComponent fileNameText = Component.literal((String)output.getAbsolutePath()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, output.getAbsolutePath())));
            player.sendSystemMessage((Component)Component.literal((String)"Wrote materials info to ").append((Component)fileNameText));
        }
    }

    private static String makeTsvLine(MaterialInstance material, PartType partType) {
        StringBuilder builder = new StringBuilder();
        MaterialsCommand.appendTsv(builder, material.get().getPackName());
        MaterialsCommand.appendTsv(builder, material.getDisplayName(partType).getString());
        MaterialsCommand.appendTsv(builder, partType.getDisplayName().getString());
        MaterialsCommand.appendTsv(builder, material.getId().toString());
        MaterialsCommand.appendTsv(builder, MaterialsCommand.getParentId(material.get()));
        for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
            Collection mods = material.getPropertyModifiers(partType, PropertyKey.of(property, (GearType)GearTypes.ALL.get()));
            Component formattedText = GearPropertyMap.formatTextUnchecked(mods, property, false);
            MaterialsCommand.appendTsv(builder, FORMAT_CODES.matcher(formattedText.getString()).replaceAll(""));
        }
        return builder.toString();
    }

    private static String getParentId(Material material) {
        Material parent = material.getParent();
        if (parent != null) {
            return SgRegistries.MATERIAL.getKey(material).toString();
        }
        return "";
    }

    private static void appendTsv(StringBuilder builder, Object value) {
        builder.append(value).append("\t");
    }

    private static Component text(String key, Object ... args) {
        return Component.translatable((String)("command.silentgear.parts." + key), (Object[])args);
    }
}

