/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.util;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.setup.GearItemSets;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public final class ModItemModelProperties {
    private ModItemModelProperties() {
    }

    public static void register(FMLClientSetupEvent event) {
        ResourceLocation pull = ResourceLocation.withDefaultNamespace((String)"pull");
        ModItemModelProperties.register(event, (Item)GearItemSets.BOW.gearItem(), pull, (stack, level, entity, par4) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
        });
        ResourceLocation pulling = ResourceLocation.withDefaultNamespace((String)"pulling");
        ModItemModelProperties.register(event, (Item)GearItemSets.BOW.gearItem(), pulling, (stack, level, entity, par4) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        ModItemModelProperties.register(event, (Item)GearItemSets.SLINGSHOT.gearItem(), pull, (stack, level, entity, par4) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
        });
        ModItemModelProperties.register(event, (Item)GearItemSets.SLINGSHOT.gearItem(), pulling, (stack, level, entity, par4) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        ModItemModelProperties.register(event, (Item)GearItemSets.CROSSBOW.gearItem(), pull, (stack, level, entity, par4) -> {
            if (entity == null) {
                return 0.0f;
            }
            return CrossbowItem.isCharged((ItemStack)stack) ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / (float)CrossbowItem.getChargeDuration((ItemStack)stack, (LivingEntity)entity);
        });
        ModItemModelProperties.register(event, (Item)GearItemSets.CROSSBOW.gearItem(), pulling, (stack, level, entity, par4) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack && !CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
        ModItemModelProperties.register(event, (Item)GearItemSets.CROSSBOW.gearItem(), ResourceLocation.withDefaultNamespace((String)"charged"), (stack, level, entity, par4) -> entity != null && CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
        ModItemModelProperties.register(event, (Item)GearItemSets.CROSSBOW.gearItem(), ResourceLocation.withDefaultNamespace((String)"firework"), (stack, level, entity, par4) -> {
            ChargedProjectiles chargedProjectile = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
            return entity != null && chargedProjectile != null && chargedProjectile.contains(Items.FIREWORK_ROCKET) ? 1.0f : 0.0f;
        });
        ModItemModelProperties.register(event, (Item)GearItemSets.SHIELD.gearItem(), ResourceLocation.withDefaultNamespace((String)"blocking"), (stack, level, entity, par4) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        SgItems.getItems(GearItem.class).forEach(item -> {
            ModItemModelProperties.register(event, item.asItem(), Const.MODEL, (stack, level, entity, par4) -> GearData.getModelIndex(stack));
            ModItemModelProperties.register(event, item.asItem(), Const.BROKEN_PROPERTY, (stack, level, entity, par4) -> GearHelper.isBroken(stack) ? 0.0f : 1.0f);
        });
    }

    private static void register(FMLClientSetupEvent event, Item item, ResourceLocation propertyId, ItemPropertyFunction function) {
        event.enqueueWork(() -> ItemProperties.register((Item)item, (ResourceLocation)propertyId, (ItemPropertyFunction)function));
    }
}

