/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.util;

import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyGroups;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.util.GearTooltipFlag;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.CoreGearPart;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;

@OnlyIn(value=Dist.CLIENT)
public final class GearClientHelper {
    private GearClientHelper() {
    }

    public static int getColor(ItemStack stack, PartType layer) {
        PartInstance part = GearData.getPartOfType(stack, layer);
        if (part != null) {
            return part.getColor(stack, 0, 0);
        }
        return 0xFFFFFF;
    }

    public static void addInformation(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        GearTooltipFlag flagTC = flag instanceof GearTooltipFlag ? (GearTooltipFlag)flag : GearTooltipFlag.withModifierKeys(flag.isAdvanced(), true, true);
        GearClientHelper.addInformation(stack, context, tooltip, flagTC);
    }

    public static void addInformation(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, GearTooltipFlag flag) {
        Item item = stack.getItem();
        if (!(item instanceof GearItem)) {
            return;
        }
        GearItem item2 = (GearItem)item;
        if (GearHelper.isBroken(stack)) {
            tooltip.add(Math.min(1, tooltip.size()), (Component)TextUtil.withColor(GearClientHelper.misc("broken", new Object[0]), Color.FIREBRICK));
        }
        if (GearData.isExampleGear(stack)) {
            tooltip.add(Math.min(1, tooltip.size()), (Component)TextUtil.withColor(GearClientHelper.misc("exampleOutput1", new Object[0]), Color.YELLOW));
            tooltip.add(Math.min(2, tooltip.size()), (Component)TextUtil.withColor(GearClientHelper.misc("exampleOutput2", new Object[0]), Color.YELLOW));
        }
        PartList constructionParts = GearData.getConstruction(stack).parts();
        List<PartInstance> sortedConstructionParts = constructionParts.toSortedList();
        if (constructionParts.getMains().isEmpty()) {
            tooltip.add((Component)TextUtil.withColor(GearClientHelper.misc("invalidParts", new Object[0]), Color.FIREBRICK));
        }
        if (!((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue()) {
            for (PartInstance part : sortedConstructionParts) {
                part.addInformation(stack, tooltip, flag);
            }
        }
        if (!((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue()) {
            GearClientHelper.addStatsInfo(stack, tooltip, flag, item2);
        }
        if (KeyTracker.isDisplayConstructionDown() && flag.showConstruction) {
            tooltip.add((Component)TextUtil.withColor(GearClientHelper.misc("tooltip.construction", new Object[0]), Color.GOLD));
            GearClientHelper.tooltipListParts(stack, tooltip, sortedConstructionParts, flag);
        } else if (flag.showConstruction) {
            tooltip.add((Component)TextUtil.withColor(TextUtil.misc("tooltip.construction", new Object[0]), Color.GOLD).append((Component)Component.literal((String)" ").append((Component)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_CONSTRUCTION), ChatFormatting.GRAY))));
        }
    }

    public static void addStatsInfo(ItemStack stack, List<Component> tooltip, GearTooltipFlag flag, GearItem item) {
        if (KeyTracker.isDisplayStatsDown() && flag.showStats) {
            tooltip.add((Component)TextUtil.withColor(GearClientHelper.misc("tooltip.properties", new Object[0]), Color.GOLD));
            TextListBuilder builder = new TextListBuilder();
            GearPropertiesData gearProperties = GearData.getProperties(stack);
            for (GearProperty<?, ?> property : GearClientHelper.getDisplayProperties(stack, flag)) {
                Object value;
                if (property == GearProperties.ENCHANTMENT_VALUE && !((Boolean)Config.Common.allowEnchanting.get()).booleanValue() || (value = gearProperties.get(property)) == null) continue;
                if (property == GearProperties.DURABILITY.get()) {
                    int durabilityLeft = stack.getMaxDamage() - stack.getDamageValue();
                    int durabilityMax = stack.getMaxDamage();
                    MutableComponent text = GearClientHelper.statText("durabilityFormat", durabilityLeft, durabilityMax);
                    builder.add(property.formatText((Component)text));
                    continue;
                }
                property.getTooltipLinesUnchecked((GearPropertyValue<?>)value, flag).forEach(builder::add);
            }
            tooltip.addAll(builder.build());
        } else if (flag.showStats) {
            tooltip.add((Component)TextUtil.withColor(TextUtil.misc("tooltip.properties", new Object[0]), Color.GOLD).append((Component)Component.literal((String)" ").append((Component)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_STATS), ChatFormatting.GRAY))));
        }
    }

    private static Iterable<GearProperty<?, ?>> getDisplayProperties(ItemStack stack, GearTooltipFlag flag) {
        if (flag.isAdvanced() && SilentGear.isDevBuild()) {
            return SgRegistries.GEAR_PROPERTY;
        }
        return GearPropertyGroups.getSortedRelevantProperties(GearHelper.getType(stack).relevantPropertyGroups());
    }

    private static MutableComponent misc(String key, Object ... formatArgs) {
        return Component.translatable((String)("misc.silentgear." + key), (Object[])formatArgs);
    }

    private static MutableComponent statText(String key, Object ... formatArgs) {
        return Component.translatable((String)("property.silentgear." + key), (Object[])formatArgs);
    }

    public static void tooltipListParts(ItemStack gear, List<Component> tooltip, Collection<PartInstance> parts, GearTooltipFlag flag) {
        TextListBuilder builder = new TextListBuilder();
        for (PartInstance part : parts) {
            if (!part.isValid() || !part.get().isVisible()) continue;
            int partNameColor = Color.blend((int)part.getColor(gear), (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
            MutableComponent partNameText = TextUtil.withColor(part.getDisplayName().copy(), partNameColor);
            builder.add((Component)(flag.isAdvanced() ? partNameText.append((Component)TextUtil.misc("spaceBrackets", part.getType().getDisplayName()).withStyle(ChatFormatting.DARK_GRAY)) : partNameText));
            if (!(part.get() instanceof CoreGearPart)) continue;
            builder.indent();
            for (MaterialInstance material : CompoundPartItem.getMaterials(part.getItem())) {
                int nameColor = material.getNameColor(part.getType(), (GearType)GearTypes.ALL.get());
                builder.add((Component)TextUtil.withColor(material.getDisplayNameWithModifiers(part.getType(), ItemStack.EMPTY), nameColor));
            }
            builder.unindent();
        }
        tooltip.addAll(builder.build());
    }

    public static boolean hasEffect(ItemStack stack) {
        return (Boolean)Config.Client.allowEnchantedEffect.get() != false && stack.isEnchanted();
    }

    public static boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }
}

