/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.salvager;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.salvager.SalvagerContainer;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgBlockEntities;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.lib.util.MathUtils;
import net.silentchaos512.lib.util.TimeUtils;

public class SalvagerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    static final int BASE_WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    private static final int INPUT_SLOT = 0;
    private static final int[] SLOTS_INPUT = new int[]{0};
    private static final int[] SLOTS_OUTPUT = IntStream.rangeClosed(1, 18).toArray();
    private static final int[] SLOTS_ALL = IntStream.rangeClosed(0, 18).toArray();
    public static final int INVENTORY_SIZE = SLOTS_INPUT.length + SLOTS_OUTPUT.length;
    private final RecipeManager.CachedCheck<SingleRecipeInput, SalvagingRecipe> quickCheck;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)INVENTORY_SIZE, (Object)ItemStack.EMPTY);
    int progress = 0;
    private final ContainerData fields = new ContainerData(){

        public int get(int index) {
            return SalvagerBlockEntity.this.progress;
        }

        public void set(int index, int value) {
            SalvagerBlockEntity.this.progress = value;
        }

        public int getCount() {
            return 1;
        }
    };

    public SalvagerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SgBlockEntities.SALVAGER.get(), pos, state);
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)SgRecipes.SALVAGING_TYPE.get()));
    }

    @Nullable
    private SalvagingRecipe getRecipe(ItemStack input) {
        if (this.level == null || input.isEmpty()) {
            return null;
        }
        RecipeHolder holder = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(this.getInputItem()), this.level).orElse(null);
        if (holder != null) {
            return (SalvagingRecipe)holder.value();
        }
        return null;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getInputItem() {
        return (ItemStack)this.items.get(0);
    }

    public ItemStack getItem(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        return ContainerHelper.removeItem(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        return ContainerHelper.takeItem(this.items, (int)pSlot);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pSlot);
        boolean flag = !pStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pSlot, (Object)pStack);
        if (pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
        if (pSlot < this.getContainerSize() - 1 && !flag) {
            this.progress = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(Player pPlayer) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)pPlayer);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SalvagerBlockEntity blockEntity) {
        ItemStack input = blockEntity.getItem(0);
        SalvagingRecipe recipe = blockEntity.getRecipe(input);
        if (recipe != null) {
            if (blockEntity.progress < BASE_WORK_TIME) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress >= BASE_WORK_TIME && blockEntity.areAllOutputSlotsFree()) {
                for (ItemStack stack : blockEntity.getSalvagedPartsWithChance(recipe, input)) {
                    int slot = blockEntity.getFreeOutputSlot();
                    if (slot > 0) {
                        blockEntity.setItem(slot, stack);
                        continue;
                    }
                    SilentGear.LOGGER.warn("Item lost in salvager: {}", (Object)stack);
                }
                blockEntity.progress = 0;
                input.shrink(1);
                if (input.isEmpty()) {
                    blockEntity.setItem(0, ItemStack.EMPTY);
                }
            }
        } else {
            blockEntity.progress = 0;
        }
    }

    private Collection<ItemStack> getSalvagedPartsWithChance(SalvagingRecipe recipe, ItemStack stack) {
        double lossRate = SalvagerBlockEntity.getLossRate(stack);
        SilentGear.LOGGER.debug("Loss rate for '{}': {}", (Object)stack, (Object)lossRate);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack part : recipe.getPossibleResults((Container)this)) {
            ItemStack copy = part.copy();
            int count = copy.getCount();
            PartInstance partData = PartInstance.from(part);
            double partLossRate = partData != null && partData.isValid() ? partData.get().getSalvageLossRate(partData, stack, lossRate) : lossRate;
            for (int i = 0; i < count; ++i) {
                if (!MathUtils.tryPercentage((Random)SilentGear.RANDOM, (double)partLossRate)) continue;
                copy.shrink(1);
            }
            if (copy.isEmpty()) continue;
            builder.add((Object)copy);
        }
        return builder.build();
    }

    private static double getLossRate(ItemStack stack) {
        int maxDamage = stack.getMaxDamage();
        double min = (Double)Config.Common.salvagerMinLossRate.get();
        if (maxDamage == 0) {
            return min;
        }
        double ratio = (double)stack.getDamageValue() / (double)maxDamage;
        return min + ratio * ((Double)Config.Common.salvagerMaxLossRate.get() - min);
    }

    private int getFreeOutputSlot() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.getItem(slot).isEmpty()) continue;
            return slot;
        }
        return -1;
    }

    private boolean areAllOutputSlotsFree() {
        for (int slot : SLOTS_OUTPUT) {
            if (this.getItem(slot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tags = super.getUpdateTag(provider);
        tags.putInt("Progress", this.progress);
        return tags;
    }

    public int[] getSlotsForFace(Direction side) {
        return switch (side) {
            case Direction.DOWN -> SLOTS_OUTPUT;
            case Direction.UP -> SLOTS_INPUT;
            default -> SLOTS_ALL;
        };
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (stack.isEmpty() || SalvagerBlockEntity.isOutputSlot(index)) {
            return false;
        }
        ItemStack current = this.getItem(index);
        if (!current.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)current)) {
            return false;
        }
        return SalvagerBlockEntity.isInputSlot(index) || super.canPlaceItem(index, stack);
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return SalvagerBlockEntity.isOutputSlot(index);
    }

    private static boolean isInputSlot(int index) {
        for (int k : SLOTS_INPUT) {
            if (index != k) continue;
            return true;
        }
        return false;
    }

    private static boolean isOutputSlot(int index) {
        for (int k : SLOTS_OUTPUT) {
            if (index != k) continue;
            return true;
        }
        return false;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.silentgear.salvager");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new SalvagerContainer(id, playerInventory, (Container)this, this.fields);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void fillStackedContents(StackedContents pContents) {
        for (ItemStack stack : this.items) {
            pContents.accountStack(stack);
        }
    }

    public void loadAdditional(CompoundTag tags, HolderLookup.Provider provider) {
        super.loadAdditional(tags, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tags, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider provider) {
        super.saveAdditional(pTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)provider);
    }
}

