/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.press;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.press.MetalPressBlock;
import net.silentchaos512.gear.block.press.MetalPressContainer;
import net.silentchaos512.gear.crafting.recipe.press.PressingRecipe;
import net.silentchaos512.gear.setup.SgBlockEntities;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.TimeUtils;

public class MetalPressBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    static final int WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    private final RecipeManager.CachedCheck<SingleRecipeInput, PressingRecipe> quickCheck;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private int progress = 0;
    private final ContainerData fields = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return MetalPressBlockEntity.this.progress;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    MetalPressBlockEntity.this.progress = value;
                }
            }
        }

        public int getCount() {
            return 1;
        }
    };

    public MetalPressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SgBlockEntities.METAL_PRESS.get(), pos, state);
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)SgRecipes.PRESSING_TYPE.get()));
    }

    @Nullable
    public PressingRecipe getRecipe() {
        if (this.level == null || this.getItem(0).isEmpty()) {
            return null;
        }
        RecipeHolder holder = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput((ItemStack)this.items.getFirst()), this.level).orElse(null);
        if (holder != null) {
            return (PressingRecipe)holder.value();
        }
        return null;
    }

    private ItemStack getWorkOutput(@Nullable PressingRecipe recipe, RegistryAccess registryAccess) {
        if (recipe != null) {
            return recipe.assemble(new SingleRecipeInput((ItemStack)this.items.getFirst()), (HolderLookup.Provider)registryAccess);
        }
        return ItemStack.EMPTY;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MetalPressBlockEntity blockEntity) {
        PressingRecipe recipe = blockEntity.getRecipe();
        if (recipe != null) {
            blockEntity.doWork(recipe, level.registryAccess());
        } else {
            blockEntity.stopWork();
        }
    }

    private void doWork(PressingRecipe recipe, RegistryAccess registryAccess) {
        assert (this.level != null);
        ItemStack current = this.getItem(1);
        ItemStack output = this.getWorkOutput(recipe, registryAccess);
        if (!current.isEmpty()) {
            int newCount = current.getCount() + output.getCount();
            if (!ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)output) || newCount > output.getMaxStackSize()) {
                this.stopWork();
                return;
            }
        }
        if (this.progress < WORK_TIME) {
            ++this.progress;
        }
        if (this.progress >= WORK_TIME && !this.level.isClientSide) {
            this.finishWork(recipe, registryAccess, current);
        }
        this.sendUpdate((BlockState)this.getBlockState().setValue((Property)MetalPressBlock.LIT, (Comparable)Boolean.valueOf(true)));
    }

    private void stopWork() {
        this.progress = 0;
        this.sendUpdate((BlockState)this.getBlockState().setValue((Property)MetalPressBlock.LIT, (Comparable)Boolean.valueOf(false)));
    }

    private void finishWork(PressingRecipe recipe, RegistryAccess registryAccess, ItemStack current) {
        ItemStack output = this.getWorkOutput(recipe, registryAccess);
        if (!current.isEmpty()) {
            current.grow(output.getCount());
        } else {
            this.setItem(1, output);
        }
        this.progress = 0;
        this.removeItem(0, 1);
    }

    private void sendUpdate(BlockState newState) {
        if (this.level == null) {
            return;
        }
        BlockState oldState = this.level.getBlockState(this.worldPosition);
        if (oldState != newState) {
            this.level.setBlock(this.worldPosition, newState, 3);
            this.level.sendBlockUpdated(this.worldPosition, oldState, newState, 3);
        }
    }

    public int[] getSlotsForFace(Direction side) {
        return new int[]{0, 1};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    protected Component getDefaultName() {
        return TextUtil.translate("container", "metal_press");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new MetalPressContainer(id, player, (Container)this, this.fields);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        return ContainerHelper.removeItem(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        return ContainerHelper.takeItem(this.items, (int)pSlot);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pSlot);
        boolean flag = !pStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pSlot, (Object)pStack);
        if (pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
        if (pSlot < this.items.size() - 1 && !flag) {
            this.progress = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(Player pPlayer) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)pPlayer);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void fillStackedContents(StackedContents pContents) {
        for (ItemStack stack : this.items) {
            pContents.accountStack(stack);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }
}

