/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.grader;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.block.grader.GraderContainer;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.modifier.GradeMaterialModifier;
import net.silentchaos512.gear.setup.SgBlockEntities;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.setup.gear.MaterialModifiers;
import net.silentchaos512.lib.util.EnumUtils;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.TimeUtils;

public class GraderBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    static final int BASE_ANALYZE_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 1.0f : 5.0f));
    static final int INPUT_SLOT = 0;
    static final int CATALYST_SLOT = 1;
    private static final int[] SLOTS_INPUT = new int[]{0, 1};
    private static final int[] SLOTS_OUTPUT = new int[]{2, 3, 4, 5};
    static final int INVENTORY_SIZE = SLOTS_INPUT.length + SLOTS_OUTPUT.length;
    private static final int[] SLOTS_ALL = IntStream.rangeClosed(0, INVENTORY_SIZE - 1).toArray();
    private NonNullList<ItemStack> items = NonNullList.withSize((int)INVENTORY_SIZE, (Object)ItemStack.EMPTY);
    private int progress = 0;
    private MaterialGrade lastGradeAttempt = MaterialGrade.NONE;
    private boolean requireClientSync = false;
    private final ContainerData fields = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> GraderBlockEntity.this.progress;
                case 1 -> GraderBlockEntity.this.lastGradeAttempt.ordinal();
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    GraderBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    GraderBlockEntity.this.lastGradeAttempt = (MaterialGrade)EnumUtils.byOrdinal((int)value, (Enum)MaterialGrade.NONE);
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public GraderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SgBlockEntities.MATERIAL_GRADER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GraderBlockEntity blockEntity) {
        ItemStack input = blockEntity.getInputStack();
        if (input.isEmpty()) {
            return;
        }
        int outputSlot = blockEntity.getFreeOutputSlot();
        if (outputSlot < 0) {
            return;
        }
        ItemStack catalyst = blockEntity.getCatalystStack();
        int catalystTier = GraderBlockEntity.getCatalystTier(catalyst);
        if (catalystTier < 1) {
            return;
        }
        MaterialInstance material = MaterialInstance.from(input);
        if (material != null && GraderBlockEntity.canGrade(input)) {
            if (blockEntity.progress < BASE_ANALYZE_TIME) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress >= BASE_ANALYZE_TIME && !level.isClientSide) {
                blockEntity.progress = 0;
                catalyst.shrink(1);
                blockEntity.tryGradeItem(input, catalystTier, material);
            }
        } else {
            blockEntity.progress = 0;
        }
    }

    private void tryGradeItem(ItemStack input, int catalystTier, MaterialInstance material) {
        MaterialGrade targetGrade;
        this.lastGradeAttempt = targetGrade = MaterialGrade.selectWithCatalyst(SilentGear.RANDOM, catalystTier);
        GradeMaterialModifier currentGradeMod = (GradeMaterialModifier)material.getModifier((IMaterialModifierType)MaterialModifiers.GRADE.get());
        if (currentGradeMod == null || targetGrade.ordinal() > currentGradeMod.grade().ordinal()) {
            ItemStack stack = input.split(1);
            targetGrade.setGradeOnStack(stack);
            InventoryUtils.mergeItem((Container)this, (int)2, (int)(2 + SLOTS_OUTPUT.length), (ItemStack)stack);
        }
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.getInputStack().isEmpty();
    }

    public ItemStack getItem(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        return ContainerHelper.removeItem(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        return ContainerHelper.takeItem(this.items, (int)pSlot);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pSlot);
        boolean flag = !pStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pSlot, (Object)pStack);
        if (pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
        if (pSlot < INVENTORY_SIZE - 1 && !flag) {
            this.progress = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(Player pPlayer) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)pPlayer);
    }

    public static boolean canGrade(ItemStack stack) {
        MaterialInstance material = MaterialInstance.from(stack);
        if (material == null) {
            return false;
        }
        GradeMaterialModifier gradeMod = (GradeMaterialModifier)material.getModifier((IMaterialModifierType)MaterialModifiers.GRADE.get());
        return gradeMod == null || gradeMod.grade() != MaterialGrade.MAX;
    }

    private ItemStack getInputStack() {
        ItemStack stack = this.getItem(0);
        if (!stack.isEmpty() && GraderBlockEntity.canGrade(stack)) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private ItemStack getCatalystStack() {
        return this.getItem(1);
    }

    private int getFreeOutputSlot() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.getItem(slot).isEmpty()) continue;
            return slot;
        }
        return -1;
    }

    public static int getCatalystTier(ItemStack stack) {
        if (!stack.isEmpty()) {
            for (int i = SgTags.Items.GRADER_CATALYSTS_TIERS.size() - 1; i >= 0; --i) {
                if (!stack.is(SgTags.Items.GRADER_CATALYSTS_TIERS.get(i))) continue;
                return i + 1;
            }
        }
        return 0;
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        this.progress = pTag.getInt("Progress");
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("Progress", this.progress);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tags = super.getUpdateTag(pRegistries);
        tags.putInt("Progress", this.progress);
        ListTag tagList = new ListTag();
        ItemStack input = this.getInputStack();
        if (!input.isEmpty()) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.putByte("Slot", (byte)0);
            tagList.add((Object)input.save(pRegistries, (Tag)itemTag));
        }
        tags.put("Items", (Tag)tagList);
        return tags;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        CompoundTag tags = pkt.getTag();
        if (tags == null) {
            return;
        }
        this.progress = tags.getInt("Progress");
        if (tags.contains("input_item")) {
            ItemStack inputItem = ItemStack.parse((HolderLookup.Provider)lookupProvider, (Tag)tags.getCompound("input_item")).orElse(ItemStack.EMPTY);
            this.setItem(0, inputItem);
        } else {
            this.setItem(0, ItemStack.EMPTY);
        }
    }

    public int[] getSlotsForFace(Direction side) {
        return switch (side) {
            case Direction.UP -> SLOTS_INPUT;
            case Direction.DOWN -> SLOTS_OUTPUT;
            default -> SLOTS_ALL;
        };
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index != 0 && index != 1) {
            return false;
        }
        ItemStack stackInSlot = this.getItem(index);
        if (stack.isEmpty() || !stackInSlot.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) {
            return false;
        }
        if (index == 0) {
            return GraderBlockEntity.canGrade(stack);
        }
        return GraderBlockEntity.getCatalystTier(stack) > 0;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index != 0 && index != 1;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.silentgear.material_grader");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new GraderContainer(id, playerInventory, (Container)this, this.fields);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void fillStackedContents(StackedContents pContents) {
        for (ItemStack stack : this.items) {
            pContents.accountStack(stack);
        }
    }
}

