/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.alloymaker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.block.IDroppableInventory;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerContainer;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerInfo;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipeInput;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.lib.util.TimeUtils;

public class AlloyMakerBlockEntity<R extends AlloyRecipe>
extends BaseContainerBlockEntity
implements IDroppableInventory,
WorldlyContainer,
StackedContentsCompatible {
    public static final int STANDARD_INPUT_SLOTS = 4;
    static final int WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    private final AlloyMakerInfo<R> info;
    private final int[] allSlots;
    private final RecipeManager.CachedCheck<AlloyRecipeInput, R> quickCheck;
    private NonNullList<ItemStack> items;
    private ItemStack outputItemHint = ItemStack.EMPTY;
    private int progress = 0;
    private boolean workEnabled = true;
    private final ContainerData fields = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> AlloyMakerBlockEntity.this.progress;
                case 1 -> {
                    if (AlloyMakerBlockEntity.this.workEnabled) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    AlloyMakerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    AlloyMakerBlockEntity.this.workEnabled = value != 0;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public AlloyMakerBlockEntity(AlloyMakerInfo<R> info, BlockPos pos, BlockState state) {
        super(info.getBlockEntityType(), pos, state);
        this.items = NonNullList.withSize((int)(info.getInputSlotCount() + 2), (Object)ItemStack.EMPTY);
        this.info = info;
        this.allSlots = IntStream.range(0, this.items.size()).toArray();
        this.quickCheck = RecipeManager.createCheck(info.getRecipeType());
    }

    protected RecipeType<R> getRecipeType() {
        return this.info.getRecipeType();
    }

    protected CompoundMaterialItem getOutputItem(List<MaterialInstance> materials) {
        return this.info.getOutputItem();
    }

    protected ItemStack getWorkOutput(@Nullable R recipe, RegistryAccess registryAccess, List<MaterialInstance> materials) {
        if (recipe != null) {
            return ((AlloyRecipe)recipe).assemble(AlloyRecipeInput.of(this), (HolderLookup.Provider)registryAccess);
        }
        return this.getOutputItem(materials).create(materials);
    }

    public int getInputSlotCount() {
        return this.getContainerSize() - 2;
    }

    public int getOutputSlotIndex() {
        return this.getContainerSize() - 2;
    }

    public int getOutputHintSlotIndex() {
        return this.getContainerSize() - 1;
    }

    public ItemStack getHintStack() {
        return this.getItem(this.getOutputHintSlotIndex());
    }

    public void encodeExtraData(FriendlyByteBuf buffer) {
        buffer.writeByte(this.items.size());
        buffer.writeByte(this.fields.getCount());
    }

    private boolean areInputsEmpty() {
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static <R extends AlloyRecipe> void tick(Level level, BlockPos pos, BlockState state, AlloyMakerBlockEntity<R> blockEntity) {
        if (blockEntity.areInputsEmpty()) {
            blockEntity.updateOutputHint(ItemStack.EMPTY);
            return;
        }
        RecipeHolder recipe = blockEntity.quickCheck.getRecipeFor((RecipeInput)AlloyRecipeInput.of(blockEntity), level).orElse(null);
        if (recipe != null) {
            blockEntity.doWork((AlloyRecipe)recipe.value(), level.registryAccess(), Collections.emptyList());
        } else {
            List<MaterialInstance> materials = blockEntity.getInputs();
            if (!AlloyMakerBlockEntity.hasMultipleMaterials(materials) || !blockEntity.canCompoundMaterials(materials)) {
                blockEntity.stopWork(true);
                return;
            }
            blockEntity.doWork(null, level.registryAccess(), materials);
        }
    }

    private void doWork(@Nullable R recipe, RegistryAccess registryAccess, List<MaterialInstance> materials) {
        assert (this.level != null);
        ItemStack current = this.getItem(this.getOutputSlotIndex());
        ItemStack output = this.getWorkOutput(recipe, registryAccess, materials);
        this.updateOutputHint(output);
        if (!current.isEmpty()) {
            int newCount = current.getCount() + output.getCount();
            if (!ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)output) || newCount > output.getMaxStackSize()) {
                this.stopWork(false);
                return;
            }
        }
        if (this.workEnabled) {
            if (this.progress < WORK_TIME) {
                ++this.progress;
            }
            if (this.progress >= WORK_TIME && !this.level.isClientSide) {
                this.finishWork(recipe, registryAccess, materials, current);
            }
        } else {
            this.stopWork(false);
        }
    }

    private void updateOutputHint(ItemStack hintStack) {
        this.setItem(this.getOutputHintSlotIndex(), hintStack);
    }

    private void stopWork(boolean clearHintItem) {
        this.progress = 0;
        if (clearHintItem) {
            this.setItem(this.getOutputHintSlotIndex(), ItemStack.EMPTY);
        }
    }

    private void finishWork(@Nullable R recipe, RegistryAccess registryAccess, List<MaterialInstance> materials, ItemStack current) {
        this.progress = 0;
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            this.removeItem(i, 1);
        }
        ItemStack output = this.getWorkOutput(recipe, registryAccess, materials);
        if (!current.isEmpty()) {
            current.grow(output.getCount());
        } else {
            this.setItem(this.getOutputSlotIndex(), output);
        }
    }

    private static boolean hasMultipleMaterials(List<MaterialInstance> materials) {
        if (materials.size() < 2) {
            return false;
        }
        Material first = materials.get(0).get();
        for (int i = 1; i < materials.size(); ++i) {
            if (materials.get(i).get() == first) continue;
            return true;
        }
        return false;
    }

    private boolean canCompoundMaterials(Iterable<MaterialInstance> materials) {
        HashSet partTypes = new HashSet(SgRegistries.PART_TYPE.stream().toList());
        for (MaterialInstance material : materials) {
            if (!this.info.acceptsMaterial(material)) {
                return false;
            }
            partTypes.removeIf(pt -> !material.getPartTypes().contains(pt));
        }
        return !partTypes.isEmpty();
    }

    private List<MaterialInstance> getInputs() {
        boolean allEmpty = true;
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            return Collections.emptyList();
        }
        ArrayList<MaterialInstance> ret = new ArrayList<MaterialInstance>();
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            MaterialInstance material = MaterialInstance.from(stack);
            if (material != null && material.get().isSimple()) {
                ret.add(material);
                continue;
            }
            return Collections.emptyList();
        }
        return ret;
    }

    @Override
    public NonNullList<ItemStack> getItemsToDrop() {
        NonNullList ret = NonNullList.create();
        for (int i = 0; i < this.getContainerSize() - 1; ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            ret.add((Object)stack);
        }
        return ret;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        return ContainerHelper.removeItem(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        return ContainerHelper.takeItem(this.items, (int)pSlot);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pSlot);
        boolean flag = !pStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pSlot, (Object)pStack);
        if (pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
        if (pSlot < this.getContainerSize() - 1 && !flag) {
            this.progress = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(Player pPlayer) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)pPlayer);
    }

    public int[] getSlotsForFace(Direction side) {
        return (int[])this.allSlots.clone();
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index < this.getInputSlotCount();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index == this.getOutputSlotIndex();
    }

    protected Component getDefaultName() {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey(this.info.getBlock());
        return Component.translatable((String)Util.makeDescriptionId((String)"container", (ResourceLocation)key));
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new AlloyMakerContainer(this.info.getContainerType(), id, player, (Container)this, this.fields, this.info.getCategories());
    }

    public void loadAdditional(CompoundTag tags, HolderLookup.Provider provider) {
        super.loadAdditional(tags, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tags, this.items, (HolderLookup.Provider)provider);
        this.progress = tags.getInt("Progress");
        this.workEnabled = tags.getBoolean("WorkEnabled");
    }

    public void saveAdditional(CompoundTag tags, HolderLookup.Provider provider) {
        super.saveAdditional(tags, provider);
        tags.putInt("Progress", this.progress);
        tags.putBoolean("WorkEnabled", this.workEnabled);
        ContainerHelper.saveAllItems((CompoundTag)tags, this.items, (HolderLookup.Provider)provider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tags = super.getUpdateTag(provider);
        tags.putInt("Progress", this.progress);
        tags.putBoolean("WorkEnabled", this.workEnabled);
        return tags;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        super.onDataPacket(net, packet, provider);
        CompoundTag tags = packet.getTag();
        if (tags != null) {
            this.progress = tags.getInt("Progress");
            this.workEnabled = tags.getBoolean("WorkEnabled");
        }
    }

    public void clearContent() {
        this.items.clear();
    }

    public void fillStackedContents(StackedContents pContents) {
        for (ItemStack stack : this.items) {
            pContents.accountStack(stack);
        }
    }
}

