/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.property;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.TraitListPropertyValue;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.util.GearTooltipFlag;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.gear.trait.Trait;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.CodecUtils;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.lib.util.Color;

public class TraitListProperty
extends GearProperty<List<TraitInstance>, TraitListPropertyValue> {
    public static final Codec<TraitListPropertyValue> CODEC = Codec.list(TraitInstance.CODEC).xmap(TraitListPropertyValue::new, GearPropertyValue::value);
    public static final StreamCodec<RegistryFriendlyByteBuf, TraitListPropertyValue> STREAM_CODEC = StreamCodec.of((buf, val) -> CodecUtils.encodeList(buf, (Collection)val.value, TraitInstance.STREAM_CODEC), buf -> new TraitListPropertyValue(CodecUtils.decodeList(buf, TraitInstance.STREAM_CODEC)));

    public TraitListProperty(GearProperty.Builder<List<TraitInstance>> builder) {
        super(builder);
    }

    @Override
    public Codec<TraitListPropertyValue> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, TraitListPropertyValue> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public TraitListPropertyValue valueOf(List<TraitInstance> value) {
        return new TraitListPropertyValue(value);
    }

    @Override
    public List<TraitInstance> compute(List<TraitInstance> baseValue, boolean filterConditions, GearType itemType, GearType statType, Collection<TraitListPropertyValue> modifiers) {
        return this.computeForGear(baseValue, filterConditions, itemType, statType, modifiers, List.of());
    }

    @Override
    public List<TraitInstance> computeForGear(List<TraitInstance> baseValue, boolean filterConditions, GearType itemType, GearType statType, Collection<TraitListPropertyValue> modifiers, List<PartInstance> parts) {
        if (modifiers.isEmpty()) {
            return baseValue;
        }
        ArrayList<TraitInstance> list = new ArrayList<TraitInstance>();
        for (TraitListPropertyValue mod : modifiers) {
            list.addAll((Collection)mod.value);
        }
        return this.computeTraits(filterConditions, itemType, baseValue, list, parts);
    }

    public List<TraitInstance> computeTraits(boolean filterConditions, GearType itemType, List<TraitInstance> baseValue, Collection<TraitInstance> traits, List<PartInstance> parts) {
        Trait[] keys;
        if (traits.isEmpty()) {
            return baseValue;
        }
        LinkedHashMap<Trait, Integer> map = new LinkedHashMap<Trait, Integer>();
        HashMap<Trait, Integer> count = new HashMap<Trait, Integer>();
        for (TraitInstance traitInstance : traits) {
            map.merge(traitInstance.getTrait(), traitInstance.getLevel(), Integer::sum);
            count.merge(traitInstance.getTrait(), 1, Integer::sum);
        }
        for (Trait trait2 : keys = map.keySet().toArray(new Trait[0])) {
            int matsWithTrait = (Integer)count.get(trait2);
            float divisor = Math.min((float)traits.size() / 2.0f, (float)matsWithTrait);
            int value = Math.round((float)((Integer)map.get(trait2)).intValue() / divisor);
            map.put(trait2, Mth.clamp((int)value, (int)1, (int)trait2.getMaxLevel()));
        }
        ArrayList<TraitInstance> arrayList = new ArrayList<TraitInstance>();
        map.forEach((trait, level) -> ret.add(TraitInstance.of(trait, (int)level, new ITraitCondition[0])));
        if (filterConditions) {
            arrayList.removeIf(trait -> !trait.conditionsMatch(PartGearKey.of(itemType, (PartType)PartTypes.NONE.get()), parts));
        }
        return arrayList;
    }

    @Override
    public List<TraitListPropertyValue> compressModifiers(Collection<TraitListPropertyValue> modifiers, PartGearKey key, List<? extends GearComponentInstance<?>> components) {
        return List.copyOf(modifiers);
    }

    @Override
    public List<TraitInstance> getZeroValue() {
        return List.of();
    }

    @Override
    public boolean isZero(List<TraitInstance> value) {
        return value.isEmpty();
    }

    @Override
    public MutableComponent formatValueWithColor(TraitListPropertyValue value, boolean addColor) {
        return this.formatValue(value).plainCopy();
    }

    @Override
    public Component formatValue(TraitListPropertyValue value) {
        return Component.literal((String)((List)value.value).stream().map(TraitInstance::getDisplayName).map(Component::getString).collect(Collectors.joining(", ")));
    }

    @Override
    public List<TraitListPropertyValue> sortForDisplay(Collection<TraitListPropertyValue> mods) {
        return List.of(this.valueOf(this.compute((List)this.baseValue, false, (GearType)GearTypes.ALL.get(), mods)));
    }

    @Override
    public List<Component> getTooltipLines(TraitListPropertyValue value, GearTooltipFlag flag) {
        ArrayList<Component> result = new ArrayList<Component>();
        List traits = (List)value.value;
        int displayIndex = TraitListProperty.getTraitDisplayIndex(traits.size(), flag);
        MutableComponent textTraits = TextUtil.withColor(TextUtil.misc("tooltip.traits", new Object[0]), Color.GOLD);
        if (displayIndex < 0 && !((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue()) {
            result.add((Component)textTraits);
        }
        int i = 0;
        for (TraitInstance trait : traits) {
            if (displayIndex < 0 || displayIndex == i) {
                int level = trait.getLevel();
                trait.getTrait().addInformation(level, result, flag, text -> {
                    if (((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue()) {
                        MutableComponent bullet = Component.literal((String)"\u2666 ");
                        return TextUtil.withColor(bullet, Color.GRAY).append(text);
                    }
                    if (displayIndex >= 0) {
                        MutableComponent colon = Component.literal((String)": ");
                        return textTraits.append((Component)TextUtil.withColor(colon, ChatFormatting.GRAY).append(text));
                    }
                    return Component.literal((String)(TextListBuilder.BULLETS[0] + " ")).append(text);
                });
            }
            ++i;
        }
        return result;
    }

    private static int getTraitDisplayIndex(int numTraits, GearTooltipFlag flag) {
        if (((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue() || KeyTracker.isDisplayTraitsDown() || numTraits == 0) {
            return -1;
        }
        return ClientTicks.ticksInGame() / 20 % numTraits;
    }
}

