/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.property;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.NumberPropertyValue;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;
import net.silentchaos512.lib.util.MathUtils;

public class NumberProperty
extends GearProperty<Float, NumberPropertyValue> {
    private static final Codec<NumberPropertyValue> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("value").forGetter(GearPropertyValue::value), (App)Operation.CODEC.optionalFieldOf("operation").forGetter(v -> Optional.of(v.operation()))).apply((Applicative)instance, (value, operation) -> new NumberPropertyValue(value.floatValue(), operation.orElse(Operation.AVERAGE))));
    public static final Codec<NumberPropertyValue> CODEC = Codec.either((Codec)Codec.FLOAT, FULL_CODEC).xmap(either -> (NumberPropertyValue)either.map(f -> new NumberPropertyValue(f.floatValue(), Operation.AVERAGE), p -> p), property -> {
        if (property.operation() == Operation.AVERAGE) {
            return Either.left((Object)((Float)property.value()));
        }
        return Either.right((Object)property);
    });
    public static final StreamCodec<FriendlyByteBuf, NumberPropertyValue> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, GearPropertyValue::value, Operation.STREAM_CODEC, NumberPropertyValue::operation, NumberPropertyValue::new);
    private final Operation defaultOperation;
    private final DisplayFormat displayFormat;
    private final boolean displayAsInt;

    public NumberProperty(Operation defaultOperation, DisplayFormat displayFormat, boolean displayAsInt, GearProperty.Builder<Float> builder) {
        super(builder);
        this.defaultOperation = defaultOperation;
        this.displayFormat = displayFormat;
        this.displayAsInt = displayAsInt;
        if (((Float)this.minimumValue).floatValue() > ((Float)this.maximumValue).floatValue()) {
            throw new IllegalArgumentException("Minimum value cannot be bigger than maximum value!");
        }
        if (((Float)this.defaultValue).floatValue() < ((Float)this.minimumValue).floatValue()) {
            throw new IllegalArgumentException("Default value cannot be lower than minimum value!");
        }
        if (((Float)this.defaultValue).floatValue() > ((Float)this.maximumValue).floatValue()) {
            throw new IllegalArgumentException("Default value cannot be bigger than maximum value!");
        }
    }

    @Override
    public Codec<NumberPropertyValue> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, NumberPropertyValue> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public Float getZeroValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    public boolean isZero(Float value) {
        return MathUtils.floatsEqual((float)value.floatValue(), (float)0.0f);
    }

    @Override
    public NumberPropertyValue valueOf(Float value) {
        return new NumberPropertyValue(value.floatValue(), Operation.AVERAGE);
    }

    public DisplayFormat getDisplayFormat() {
        return this.displayFormat;
    }

    public boolean isDisplayAsInt() {
        return this.displayAsInt;
    }

    public float clampValue(float value) {
        value = Mth.clamp((float)value, (float)((Float)this.minimumValue).floatValue(), (float)((Float)this.maximumValue).floatValue());
        return value;
    }

    @Override
    public Float compute(Float baseValue, boolean clampResult, GearType itemType, GearType statType, Collection<NumberPropertyValue> modifiers) {
        if (modifiers.isEmpty()) {
            return baseValue;
        }
        float f0 = baseValue.floatValue();
        f0 += NumberProperty.getWeightedAverage(modifiers, Operation.AVERAGE);
        for (NumberPropertyValue mod : modifiers) {
            if (mod.operation() != Operation.MAX) continue;
            f0 = Math.max(f0, ((Float)mod.value()).floatValue());
        }
        float f1 = f0;
        for (NumberPropertyValue mod : modifiers) {
            if (mod.operation() != Operation.MULTIPLY_BASE) continue;
            f1 += f0 * ((Float)mod.value()).floatValue();
        }
        for (NumberPropertyValue mod : modifiers) {
            if (mod.operation() != Operation.MULTIPLY_TOTAL) continue;
            f1 *= 1.0f + ((Float)mod.value()).floatValue();
        }
        for (NumberPropertyValue mod : modifiers) {
            if (mod.operation() != Operation.ADD) continue;
            f1 += ((Float)mod.value()).floatValue();
        }
        return Float.valueOf(clampResult ? this.clampValue(f1) : f1);
    }

    @Override
    public List<NumberPropertyValue> compressModifiers(Collection<NumberPropertyValue> modifiers, PartGearKey key, List<? extends GearComponentInstance<?>> components) {
        ArrayList<NumberPropertyValue> result = new ArrayList<NumberPropertyValue>();
        for (Operation operation : Operation.values()) {
            List<NumberPropertyValue> modsForOp = modifiers.stream().filter(m -> m.operation() == operation).toList();
            if (modsForOp.size() > 1) {
                result.add(NumberProperty.compressModifiers(modsForOp, operation));
                continue;
            }
            if (modsForOp.size() != 1) continue;
            result.add(modsForOp.getFirst());
        }
        return result;
    }

    private static NumberPropertyValue compressModifiers(Collection<NumberPropertyValue> mods, Operation operation) {
        if (operation == Operation.MAX) {
            return mods.stream().max((o1, o2) -> Float.compare(((Float)o1.value()).floatValue(), ((Float)o2.value()).floatValue())).orElse(new NumberPropertyValue(0.0f, operation));
        }
        float primaryMod = NumberProperty.getPrimaryMod(mods, operation);
        float ret = 0.0f;
        float totalWeight = 0.0f;
        for (NumberPropertyValue mod : mods) {
            if (mod.operation() != operation) continue;
            float weight = 1.0f + ((Float)mod.value()).floatValue() / (1.0f + Math.abs(primaryMod));
            totalWeight += weight;
            ret += ((Float)mod.value()).floatValue() * weight;
        }
        float value = totalWeight > 0.0f ? ret / totalWeight : ret;
        return new NumberPropertyValue(value, operation);
    }

    private static float getPrimaryMod(Iterable<NumberPropertyValue> modifiers, Operation op) {
        float primaryMod = -1.0f;
        for (NumberPropertyValue mod : modifiers) {
            if (mod.operation() != op || !(primaryMod < 0.0f)) continue;
            primaryMod = ((Float)mod.value()).floatValue();
        }
        return primaryMod > 0.0f ? primaryMod : 1.0f;
    }

    public static float getWeightedAverage(Collection<NumberPropertyValue> modifiers, Operation op) {
        float primaryMod = NumberProperty.getPrimaryMod(modifiers, op);
        float ret = 0.0f;
        float totalWeight = 0.0f;
        for (NumberPropertyValue mod : modifiers) {
            if (mod.operation() != op) continue;
            float weight = NumberProperty.getModifierWeight(mod, primaryMod);
            totalWeight += weight;
            ret += ((Float)mod.value()).floatValue() * weight;
        }
        return totalWeight > 0.0f ? ret / totalWeight : ret;
    }

    private static float getModifierWeight(NumberPropertyValue mod, float primaryMod) {
        return 1.0f + ((Float)mod.value).floatValue() / (1.0f + Math.abs(primaryMod));
    }

    @Override
    public NumberPropertyValue applySynergy(NumberPropertyValue value, float synergy) {
        float multiplier = synergy - 1.0f;
        float newNumberValue = ((Float)value.value()).floatValue() + Math.abs(((Float)value.value()).floatValue()) * multiplier;
        return new NumberPropertyValue(newNumberValue, value.operation());
    }

    @Override
    public MutableComponent formatValueWithColor(NumberPropertyValue value, boolean addColor) {
        return value.operation().formatNumberValue(this, ((Float)value.value).floatValue(), this.getPreferredDecimalPlaces(value), addColor);
    }

    @Override
    public int getPreferredDecimalPlaces(NumberPropertyValue value) {
        boolean isMultiply = value.operation() == Operation.MULTIPLY_BASE || value.operation() == Operation.MULTIPLY_TOTAL;
        return this.isDisplayAsInt() && !isMultiply ? 0 : 2;
    }

    @Override
    public List<NumberPropertyValue> sortForDisplay(Collection<NumberPropertyValue> mods) {
        ArrayList<NumberPropertyValue> list = new ArrayList<NumberPropertyValue>(mods);
        list.sort(Comparator.comparing(mod -> mod.operation().ordinal()));
        return list;
    }

    @Override
    public Component formatValue(NumberPropertyValue value) {
        return value.operation().formatNumberValue(this, ((Float)value.value).floatValue(), this.getPreferredDecimalPlaces(value), false);
    }

    public static enum Operation {
        AVERAGE("avg"),
        MAX("max"),
        ADD("add"),
        MULTIPLY_BASE("mul1"),
        MULTIPLY_TOTAL("mul2");

        public static final Codec<Operation> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Operation> STREAM_CODEC;
        private final String alias;
        private static final Pattern REGEX_TRIM_TO_INT;
        private static final Pattern REGEX_REMOVE_TRAILING_ZEROS;

        private Operation(String alias) {
            this.alias = alias;
        }

        public MutableComponent formatNumberValue(NumberProperty property, float value, @Nonnegative int decimalPlaces, boolean addColor) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> this.formatAdd(property, value, decimalPlaces, addColor);
                case 0 -> this.formatAvg(property, value, decimalPlaces, addColor);
                case 1 -> this.formatMax(property, value, decimalPlaces, addColor);
                case 3 -> this.formatMul1(property, value, decimalPlaces, addColor);
                case 4 -> this.formatMul2(property, value, decimalPlaces, addColor);
            };
        }

        private MutableComponent formatAdd(NumberProperty property, float value, @Nonnegative int decimalPlaces, boolean addColor) {
            String format = "%s%." + decimalPlaces + "f";
            Color color = Operation.getFormattedColor(value, 0.0f, addColor);
            String text = Operation.trimNumber(String.format(format, value < 0.0f ? "" : "+", Float.valueOf(value)));
            return TextUtil.withColor(Component.literal((String)text), color);
        }

        private MutableComponent formatAvg(NumberProperty property, float value, @Nonnegative int decimalPlaces, boolean addColor) {
            Object text;
            Color color = Operation.getFormattedColor(value, 0.0f, addColor);
            if (property.getDisplayFormat() == DisplayFormat.PERCENTAGE) {
                text = Math.round(value * 100.0f) + "%";
            } else {
                String format = "%s%." + decimalPlaces + "f%s";
                String ret = Operation.trimNumber(String.format(format, "", Float.valueOf(value), ""));
                text = property.getDisplayFormat() == DisplayFormat.MULTIPLIER ? ret + "x" : ret;
            }
            return TextUtil.withColor(Component.literal((String)text), color);
        }

        private MutableComponent formatMax(NumberProperty property, float value, @Nonnegative int decimalPlaces, boolean addColor) {
            String format = "%s%." + decimalPlaces + "f";
            String text = Operation.trimNumber(String.format(format, "\u2191", Float.valueOf(value)));
            return TextUtil.withColor(Component.literal((String)text), Color.WHITE);
        }

        private MutableComponent formatMul1(NumberProperty property, float value, @Nonnegative int decimalPlaces, boolean addColor) {
            int percent = Math.round(100.0f * value);
            Color color = Operation.getFormattedColor(percent, 0.0f, addColor);
            String text = Operation.trimNumber(String.format("%s%d%%", percent < 0 ? "" : "+", percent));
            return TextUtil.withColor(Component.literal((String)text), color);
        }

        private MutableComponent formatMul2(NumberProperty property, float value, @Nonnegative int decimalPlaces, boolean addColor) {
            String format = "%s%." + decimalPlaces + "f";
            float val = 1.0f + value;
            Color color = Operation.getFormattedColor(val, 1.0f, addColor);
            String text = Operation.trimNumber(String.format(format, "x", Float.valueOf(val)));
            return TextUtil.withColor(Component.literal((String)text), color);
        }

        private static String trimNumber(CharSequence str) {
            String trimToInt = REGEX_TRIM_TO_INT.matcher(str).replaceFirst("");
            if (trimToInt.contains(".")) {
                return REGEX_REMOVE_TRAILING_ZEROS.matcher(trimToInt).replaceFirst("");
            }
            return trimToInt;
        }

        private static Color getFormattedColor(float val, float whiteVal, boolean addColor) {
            if (!addColor) {
                return Color.WHITE;
            }
            return val < whiteVal ? Color.INDIANRED : (MathUtils.floatsEqual((float)val, (float)whiteVal) ? Color.WHITE : Color.LIGHTGREEN);
        }

        static {
            CODEC = Codec.STRING.comapFlatMap(s -> {
                for (Operation op : Operation.values()) {
                    if (!s.equalsIgnoreCase(op.name()) && !s.equalsIgnoreCase(op.alias)) continue;
                    return DataResult.success((Object)((Object)op));
                }
                return DataResult.error(() -> "Unknown operation: " + s);
            }, Enum::name);
            STREAM_CODEC = StreamCodec.of((buf, op) -> buf.writeVarInt(op.ordinal()), buf -> Operation.values()[buf.readVarInt()]);
            REGEX_TRIM_TO_INT = Pattern.compile("\\.0+$");
            REGEX_REMOVE_TRAILING_ZEROS = Pattern.compile("0+$");
        }
    }

    public static enum DisplayFormat {
        UNIT,
        MULTIPLIER,
        PERCENTAGE;

    }
}

