/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.property;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.CodecUtils;
import org.jetbrains.annotations.NotNull;

public class GearPropertyMap
implements Multimap<PropertyKey<?, ?>, GearPropertyValue<?>> {
    public static final Codec<GearPropertyMap> CODEC = Codec.dispatchedMap(PropertyKey.CODEC, key -> CodecUtils.singleOrListCodec(key.property().codec())).xmap(map -> {
        GearPropertyMap ret = new GearPropertyMap();
        map.forEach(ret::putAll);
        return ret;
    }, propertyMap -> {
        LinkedHashMap ret = new LinkedHashMap();
        propertyMap.keySet().forEach(key -> ret.put(key, new ArrayList(propertyMap.getValues((PropertyKey)key))));
        return ret;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, GearPropertyMap> STREAM_CODEC = StreamCodec.of(GearPropertyMap::encode, GearPropertyMap::decode);
    public static final GearPropertyMap EMPTY = new GearPropertyMap();
    private final Multimap<PropertyKey<?, ?>, GearPropertyValue<?>> map = MultimapBuilder.linkedHashKeys().arrayListValues().build();

    public GearPropertyMap() {
    }

    public GearPropertyMap(GearPropertyMap values) {
        this.map.putAll((Multimap)values);
    }

    public Immutable toImmutable() {
        return new Immutable(this);
    }

    public GearPropertyMap toMutable() {
        return this;
    }

    public static Component formatTextUnchecked(Collection<? extends GearPropertyValue<?>> mods, GearProperty<?, ?> property, boolean addModColors) {
        return property.formatModifiersUnchecked(mods, addModColors);
    }

    public static <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> MutableComponent formatText(Collection<V> mods, P property, int maxDecimalPlaces) {
        return GearPropertyMap.formatText(mods, property, maxDecimalPlaces, false);
    }

    public static <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> MutableComponent formatText(Collection<V> mods, P property, int maxDecimalPlaces, boolean addModColors) {
        if (mods.size() == 1) {
            GearPropertyValue inst = (GearPropertyValue)mods.iterator().next();
            int decimalPlaces = property.getPreferredDecimalPlaces((GearPropertyValue)inst);
            return property.formatValueWithColor((GearPropertyValue)inst, addModColors);
        }
        MutableComponent result = Component.literal((String)"");
        List<V> toSort = property.sortForDisplay(mods);
        for (GearPropertyValue inst : toSort) {
            if (!result.getSiblings().isEmpty()) {
                result.append(", ");
            }
            result.append((Component)property.formatValueWithColor((GearPropertyValue)inst, addModColors));
        }
        return result;
    }

    private static void encode(RegistryFriendlyByteBuf buf, GearPropertyMap map) {
        buf.writeVarInt(map.keySet().size());
        map.keySet().forEach(key -> {
            PropertyKey.STREAM_CODEC.encode((Object)buf, key);
            Collection<GearPropertyValue<?>> values = map.get((PropertyKey<?, ?>)key);
            buf.writeVarInt(values.size());
            values.forEach(val -> key.property().rawStreamCodec().encode((Object)buf, val));
        });
    }

    private static GearPropertyMap decode(RegistryFriendlyByteBuf buf) {
        GearPropertyMap ret = new GearPropertyMap();
        int keyCount = buf.readVarInt();
        for (int i = 0; i < keyCount; ++i) {
            PropertyKey key = (PropertyKey)PropertyKey.STREAM_CODEC.decode((Object)buf);
            int propertyCount = buf.readVarInt();
            for (int j = 0; j < propertyCount; ++j) {
                GearPropertyValue value = (GearPropertyValue)key.property().streamCodec().decode((Object)buf);
                ret.put(key, value);
            }
        }
        return ret.toImmutable();
    }

    public Set<GearProperty<?, ?>> getPropertyTypes() {
        HashSet set = new HashSet();
        for (PropertyKey<?, ?> key : this.keySet()) {
            set.add(key.property());
        }
        return set;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(@Nullable Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(@Nullable Object value) {
        return this.map.containsValue(value);
    }

    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        return this.map.containsEntry(key, value);
    }

    public <V, I extends GearPropertyValue<V>> boolean put(GearProperty<V, I> stat, GearType gearType, I value) {
        return this.put(PropertyKey.of(stat, gearType), value);
    }

    public boolean put(@Nullable PropertyKey<?, ?> key, @Nullable GearPropertyValue<?> value) {
        return this.map.put(key, value);
    }

    public boolean remove(@Nullable Object key, @Nullable Object value) {
        return this.map.remove(key, value);
    }

    public boolean putAll(@Nullable PropertyKey<?, ?> key, @Nonnull Iterable<? extends GearPropertyValue<?>> values) {
        return this.map.putAll(key, values);
    }

    public boolean putAll(@Nonnull Multimap<? extends PropertyKey<?, ?>, ? extends GearPropertyValue<?>> multimap) {
        return this.map.putAll(multimap);
    }

    public Collection<GearPropertyValue<?>> replaceValues(@Nullable PropertyKey<?, ?> key, @Nonnull Iterable<? extends GearPropertyValue<?>> values) {
        return this.map.replaceValues(key, values);
    }

    public Collection<GearPropertyValue<?>> removeAll(@Nullable Object key) {
        return this.map.removeAll(key);
    }

    public void clear() {
        this.map.clear();
    }

    public <T, V extends GearPropertyValue<T>> Collection<V> getValues(GearProperty<T, V> stat, GearType gearType) {
        return this.get(PropertyKey.of(stat, gearType));
    }

    public <T, V extends GearPropertyValue<T>> Collection<V> getValues(PropertyKey<T, V> key) {
        return this.get(key);
    }

    public Collection<GearPropertyValue<?>> get(@Nullable PropertyKey<?, ?> key) {
        if (key == null || this.map.containsKey(key)) {
            return this.map.get(key);
        }
        for (PropertyKey<?, ?> parent = key.getParent(); parent != null; parent = parent.getParent()) {
            if (!this.map.containsKey(parent)) continue;
            return this.map.get(parent);
        }
        return Collections.emptyList();
    }

    public PropertyKey<?, ?> getMostSpecificKey(PropertyKey<?, ?> key) {
        if (this.map.containsKey(key)) {
            return key;
        }
        for (PropertyKey<?, ?> parent = key.getParent(); parent != null; parent = parent.getParent()) {
            if (!this.map.containsKey(parent)) continue;
            return parent;
        }
        return PropertyKey.of(key.property(), (GearType)GearTypes.ALL.get());
    }

    public Set<PropertyKey<?, ?>> keySet() {
        return this.map.keySet();
    }

    public Multiset<PropertyKey<?, ?>> keys() {
        return this.map.keys();
    }

    public Collection<GearPropertyValue<?>> values() {
        return this.map.values();
    }

    public Collection<Map.Entry<PropertyKey<?, ?>, GearPropertyValue<?>>> entries() {
        return this.map.entries();
    }

    public Map<PropertyKey<?, ?>, Collection<GearPropertyValue<?>>> asMap() {
        return this.map.asMap();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GearPropertyMap that = (GearPropertyMap)obj;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public static final class Immutable
    extends GearPropertyMap {
        public static final Codec<Immutable> CODEC = CODEC.xmap(GearPropertyMap::toImmutable, Immutable::toMutable);

        public Immutable(GearPropertyMap values) {
            super(values);
        }

        @Override
        public GearPropertyMap toMutable() {
            return new GearPropertyMap(this);
        }

        @Override
        public <V, I extends GearPropertyValue<V>> boolean put(GearProperty<V, I> stat, GearType gearType, I value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean put(@Nullable PropertyKey<?, ?> key, @Nullable GearPropertyValue<?> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(@Nullable Object key, @Nullable Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean putAll(@Nullable PropertyKey<?, ?> key, @NotNull Iterable<? extends GearPropertyValue<?>> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean putAll(@NotNull Multimap<? extends PropertyKey<?, ?>, ? extends GearPropertyValue<?>> multimap) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<GearPropertyValue<?>> replaceValues(@Nullable PropertyKey<?, ?> key, @NotNull Iterable<? extends GearPropertyValue<?>> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<GearPropertyValue<?>> removeAll(@Nullable Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

