/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.property;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.property.GearPropertyGroup;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.util.GearTooltipFlag;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;

public abstract class GearProperty<T, V extends GearPropertyValue<T>> {
    protected final T baseValue;
    protected final T defaultValue;
    protected final T minimumValue;
    protected final T maximumValue;
    protected final GearPropertyGroup group;
    protected final Color nameColor;
    protected final boolean affectedBySynergy;
    protected final boolean affectedByGrades;
    protected final boolean visible;

    protected GearProperty(Builder<T> builder) {
        builder.validate();
        this.baseValue = builder.baseValue;
        this.defaultValue = builder.defaultValue;
        this.minimumValue = builder.minimumValue;
        this.maximumValue = builder.maximumValue;
        this.affectedBySynergy = builder.affectedBySynergy;
        this.affectedByGrades = builder.affectedByGrades;
        this.group = builder.group;
        this.nameColor = builder.nameColor;
        this.visible = builder.visible;
    }

    public abstract Codec<V> codec();

    public abstract StreamCodec<? super RegistryFriendlyByteBuf, V> streamCodec();

    public StreamCodec<FriendlyByteBuf, GearPropertyValue<?>> rawStreamCodec() {
        return this.streamCodec();
    }

    public abstract V valueOf(T var1);

    public T compute(Collection<V> modifiers) {
        return this.compute(this.baseValue, true, (GearType)GearTypes.ALL.get(), modifiers);
    }

    public T compute(T baseValue, Collection<V> modifiers) {
        return this.compute(baseValue, true, (GearType)GearTypes.ALL.get(), modifiers);
    }

    public T compute(T baseValue, boolean clampResult, GearType gearType, Collection<V> modifiers) {
        return this.compute(baseValue, clampResult, gearType, gearType, modifiers);
    }

    public abstract T compute(T var1, boolean var2, GearType var3, GearType var4, Collection<V> var5);

    public T computeForGear(T baseValue, boolean clampResult, GearType itemType, GearType statType, Collection<V> modifiers, List<PartInstance> parts) {
        return this.compute(baseValue, clampResult, itemType, statType, modifiers);
    }

    public V computeUnchecked(boolean clampResult, GearType itemType, GearType statType, Collection<GearPropertyValue<?>> modifiers) {
        return this.valueOf(this.compute(this.getBaseValue(), clampResult, itemType, statType, modifiers));
    }

    public V computeUncheckedForGear(GearType itemType, GearType statType, Collection<GearPropertyValue<?>> modifiers, List<PartInstance> parts) {
        return this.valueOf(this.computeForGear(this.getBaseValue(), true, itemType, statType, modifiers, parts));
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getBaseValue() {
        return this.baseValue;
    }

    public T getMinimumValue() {
        return this.minimumValue;
    }

    public T getMaximumValue() {
        return this.maximumValue;
    }

    public abstract T getZeroValue();

    public abstract boolean isZero(T var1);

    public boolean isAffectedByGrades() {
        return this.affectedByGrades;
    }

    public boolean isAffectedBySynergy() {
        return this.affectedBySynergy;
    }

    public GearPropertyGroup getGroup() {
        return this.group;
    }

    public abstract List<V> compressModifiers(Collection<V> var1, PartGearKey var2, List<? extends GearComponentInstance<?>> var3);

    public V applySynergy(V value, float synergy) {
        return value;
    }

    public List<Component> getTooltipLines(V value, GearTooltipFlag flag) {
        return List.of(this.formatText(value, flag));
    }

    public final List<Component> getTooltipLinesUnchecked(GearPropertyValue<?> value, GearTooltipFlag flag) {
        return List.of(this.formatTextUnchecked(value, flag));
    }

    public final Component formatTextUnchecked(GearPropertyValue<?> value, GearTooltipFlag flag) {
        return this.formatText(value, flag);
    }

    public Component formatText(V value, GearTooltipFlag flag) {
        Component valueText = this.formatValue(value);
        return this.formatText(valueText);
    }

    public Component formatText(Component valueText) {
        MutableComponent propertyName = TextUtil.withColor(this.getDisplayName(), this.nameColor);
        return Component.translatable((String)"property.silentgear.displayFormat", (Object[])new Object[]{propertyName, valueText});
    }

    public abstract Component formatValue(V var1);

    public abstract MutableComponent formatValueWithColor(V var1, boolean var2);

    public Component formatModifiersUnchecked(Collection<? extends GearPropertyValue<?>> mods, boolean addModColors) {
        return this.formatModifiers(mods, addModColors);
    }

    public Component formatModifiers(Collection<V> mods, boolean addModColors) {
        if (mods.size() == 1) {
            GearPropertyValue inst = (GearPropertyValue)mods.iterator().next();
            int decimalPlaces = this.getPreferredDecimalPlaces(inst);
            return this.formatValueWithColor(inst, addModColors);
        }
        MutableComponent result = Component.literal((String)"");
        List<V> toSort = this.sortForDisplay(mods);
        for (GearPropertyValue value : toSort) {
            if (!result.getSiblings().isEmpty()) {
                result.append(", ");
            }
            result.append((Component)this.formatValueWithColor(value, addModColors));
        }
        return result;
    }

    public MutableComponent formatModifiersWithColorUnchecked(Collection<GearPropertyValue<?>> mods, boolean addColor) {
        V value = this.valueOf(this.compute(mods));
        return this.formatValueWithColor(value, addColor);
    }

    public int getPreferredDecimalPlaces(V value) {
        return 0;
    }

    public List<V> sortForDisplay(Collection<V> mods) {
        return new ArrayList<V>(mods);
    }

    public MutableComponent getDisplayName() {
        ResourceLocation name = SgRegistries.GEAR_PROPERTY.getKey((Object)this);
        if (name == null) {
            return Component.literal((String)"ERROR");
        }
        return Component.translatable((String)("property." + name.getNamespace() + "." + name.getPath()));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GearProperty)) {
            return false;
        }
        GearProperty other = (GearProperty)obj;
        ResourceLocation key = SgRegistries.GEAR_PROPERTY.getKey((Object)this);
        assert (key != null);
        return key.equals((Object)SgRegistries.GEAR_PROPERTY.getKey((Object)other));
    }

    public int hashCode() {
        ResourceLocation key = SgRegistries.GEAR_PROPERTY.getKey((Object)this);
        return key != null ? key.hashCode() : super.hashCode();
    }

    public static class Builder<T> {
        private final T baseValue;
        private final T defaultValue;
        private final T minimumValue;
        private final T maximumValue;
        private GearPropertyGroup group;
        private Color nameColor;
        private boolean affectedBySynergy;
        private boolean affectedByGrades;
        private boolean visible;

        public Builder(T defaultValue) {
            this(defaultValue, defaultValue);
        }

        public Builder(T defaultValue, T baseValue) {
            this(defaultValue, baseValue, defaultValue, defaultValue);
        }

        public Builder(T defaultValue, T baseValue, T minimumValue, T maximumValue) {
            this.defaultValue = defaultValue;
            this.baseValue = baseValue;
            this.minimumValue = minimumValue;
            this.maximumValue = maximumValue;
        }

        public void validate() {
            if (this.group == null) {
                throw new IllegalStateException("Gear property group is null");
            }
            if (this.nameColor == null) {
                throw new IllegalStateException("Gear property name color is null");
            }
        }

        public Builder<T> group(GearPropertyGroup category) {
            this.group = category;
            if (this.nameColor == null) {
                this.nameColor = this.group.getColor();
            }
            return this;
        }

        public Builder<T> nameColor(Color color) {
            this.nameColor = color;
            return this;
        }

        public Builder<T> affectedBySynergy(boolean value) {
            this.affectedBySynergy = value;
            return this;
        }

        public Builder<T> affectedByGrades(boolean value) {
            this.affectedByGrades = value;
            return this;
        }

        public Builder<T> visible(boolean visible) {
            this.visible = visible;
            return this;
        }
    }
}

