/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.IProxy;
import net.silentchaos512.gear.SideProxy;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="silentgear")
public final class SilentGear {
    public static final String MOD_ID = "silentgear";
    public static final String MOD_NAME = "Silent Gear";
    public static final String RESOURCE_PREFIX = "silentgear:";
    public static final Random RANDOM = new Random();
    public static final RandomSource RANDOM_SOURCE = RandomSource.create();
    public static final Logger LOGGER = LogManager.getLogger((String)"Silent Gear");
    public static SilentGear INSTANCE;
    public static IProxy PROXY;

    public SilentGear(IEventBus modEventBus, ModContainer modContainer) {
        INSTANCE = this;
        PROXY = FMLEnvironment.dist == Dist.CLIENT ? new SideProxy.Client(modEventBus) : new SideProxy.Server(modEventBus);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.Common.SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.Client.SPEC);
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.registerEventHandlers(modEventBus);
        }
    }

    public static String getVersion() {
        Optional o = ModList.get().getModContainerById(MOD_ID);
        if (o.isPresent()) {
            return ((ModContainer)o.get()).getModInfo().getVersion().toString();
        }
        return "0.0.0";
    }

    @Deprecated
    public static String getVersion(boolean correctInDev) {
        return SilentGear.getVersion();
    }

    public static boolean isDevBuild() {
        return "NONE".equals(SilentGear.getVersion()) || !FMLLoader.isProduction();
    }

    public static ResourceLocation getId(String path) {
        if (path.contains(":")) {
            if (path.startsWith(MOD_ID)) {
                return ResourceLocation.tryParse((String)path);
            }
            throw new IllegalArgumentException("path contains namespace other than silentgear");
        }
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @Nullable
    public static ResourceLocation getIdWithDefaultNamespace(String name) {
        if (name.contains(":")) {
            return ResourceLocation.tryParse((String)name);
        }
        return ResourceLocation.tryParse((String)(RESOURCE_PREFIX + name));
    }

    public static String shortenId(@Nullable ResourceLocation id) {
        if (id == null) {
            return "null";
        }
        if (MOD_ID.equals(id.getNamespace())) {
            return id.getPath();
        }
        return id.toString();
    }
}

