/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.utils;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class GuiUtils {
    public static void drawSpecial(GuiGraphics graphics, Consumer<MultiBufferSource> consumer) {
        MultiBufferSource.BufferSource bufferSource = graphics.bufferSource();
        consumer.accept((MultiBufferSource)bufferSource);
        bufferSource.endBatch();
    }

    public static void blitGuiTex(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height) {
        graphics.blit(texture, x, y, u, v, textureWidth, textureHeight, width, height);
    }

    public static void blitGuiTexColor(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        graphics.setColor(r, g, b, a);
        graphics.blit(texture, x, y, u, v, textureWidth, textureHeight, width, height);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void blitSprite(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        graphics.blitSprite(sprite, x, y, width, height);
    }

    public static MutableComponent translatableFallback(String key, Component fallback) {
        if (Language.getInstance().has(key)) {
            return Component.translatable((String)key);
        }
        return fallback.copy();
    }

    public static String shortenString(String string, Font font, int maxWidth, String suffix) {
        if (((String)string).isEmpty()) {
            return string;
        }
        boolean firstIter = true;
        while (font.width((String)string) > maxWidth) {
            string = ((String)string).substring(0, Math.max(((String)string).length() - 1 - (firstIter ? 1 : suffix.length() + 1), 0)).trim();
            if (((String)(string = (String)string + suffix)).equals(suffix)) break;
            firstIter = false;
        }
        return string;
    }

    public static void setPixelARGB(NativeImage nativeImage, int x, int y, int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        int abgr = a << 24 | b << 16 | g << 8 | r;
        nativeImage.setPixelRGBA(x, y, abgr);
    }
}

