/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.dropdown;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownController;
import dev.isxander.yacl3.gui.controllers.dropdown.DropdownWidget;
import dev.isxander.yacl3.gui.controllers.string.StringControllerElement;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class AbstractDropdownControllerElement<T, U>
extends StringControllerElement {
    private final AbstractDropdownController<T> dropdownController;
    protected DropdownWidget<T> dropdownWidget;
    protected boolean dropdownVisible = false;
    protected List<U> matchingValues = null;

    public AbstractDropdownControllerElement(AbstractDropdownController<T> control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim, false);
        this.dropdownController = control;
        this.dropdownController.option.addListener((opt, val) -> {
            this.matchingValues = this.computeMatchingValues();
        });
    }

    public void ensureValidValue() {
        if (!this.dropdownController.isValueValid(this.inputField)) {
            if (this.dropdownWidget == null) {
                this.inputField = this.dropdownController.getValidValue(this.inputField);
            } else {
                this.inputField = this.dropdownController.getValidValue(this.inputField, this.dropdownWidget.selectedIndex());
                this.dropdownWidget.resetSelectedIndex();
            }
            this.caretPos = this.getDefaultCaretPos();
            this.matchingValues = this.computeMatchingValues();
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            if (!this.dropdownVisible) {
                this.createDropdownWidget();
                this.doSelectAll();
            }
            return true;
        }
        return false;
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused) {
            this.doSelectAll();
            super.setFocused(true);
        } else {
            this.unfocus();
        }
    }

    @Override
    public void unfocus() {
        if (this.dropdownVisible) {
            this.removeDropdownWidget();
        }
        super.unfocus();
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.inputFieldFocused) {
            return false;
        }
        if (this.dropdownVisible) {
            switch (keyCode) {
                case 264: {
                    this.dropdownWidget.selectNextEntry();
                    return true;
                }
                case 265: {
                    this.dropdownWidget.selectPreviousEntry();
                    return true;
                }
                case 258: {
                    if (Screen.hasShiftDown()) {
                        this.dropdownWidget.selectPreviousEntry();
                    } else {
                        this.dropdownWidget.selectNextEntry();
                    }
                    return true;
                }
            }
        } else if (keyCode == 257 || keyCode == 335) {
            this.createDropdownWidget();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (!this.inputFieldFocused) {
            return false;
        }
        if (!this.dropdownVisible) {
            this.createDropdownWidget();
        }
        return super.charTyped(chr, modifiers);
    }

    @Override
    protected int getValueColor() {
        if (this.inputFieldFocused && !this.dropdownController.isValueValid(this.inputField)) {
            return -1023872;
        }
        return super.getValueColor();
    }

    @Override
    public boolean modifyInput(Consumer<StringBuilder> builder2) {
        boolean success = super.modifyInput(builder2);
        if (success) {
            this.matchingValues = this.computeMatchingValues();
        }
        return success;
    }

    public abstract List<U> computeMatchingValues();

    public boolean matchingValue(String value) {
        return value.toLowerCase().contains(this.inputField.toLowerCase());
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.matchingValues == null) {
            this.matchingValues = this.computeMatchingValues();
        }
        super.render(graphics, mouseX, mouseY, delta);
    }

    void renderDropdownEntry(GuiGraphics graphics, Dimension<Integer> entryDimension, int index) {
        this.renderDropdownEntry(graphics, entryDimension, this.matchingValues.get(index));
    }

    protected void renderDropdownEntry(GuiGraphics graphics, Dimension<Integer> entryDimension, U value) {
        String entry = this.getString(value);
        Object text = entry.isBlank() ? Component.translatable((String)"yacl.control.text.blank").withStyle(ChatFormatting.GRAY) : this.shortenString(entry);
        graphics.drawString(this.textRenderer, text, entryDimension.xLimit() - this.textRenderer.width((FormattedText)text) - this.getDropdownEntryPadding(), this.getTextY(entryDimension), -1, true);
    }

    protected int getTextY(Dimension<Integer> dim) {
        float f = (float)dim.y().intValue() + (float)dim.height().intValue() / 2.0f;
        Objects.requireNonNull(this.textRenderer);
        return (int)(f - 9.0f / 2.0f);
    }

    @Override
    public void setDimension(Dimension<Integer> dim) {
        super.setDimension(dim);
        if (this.dropdownWidget != null) {
            this.dropdownWidget.setDimension(this.dropdownWidget.getDimension().withY(this.getDimension().y()));
            if (this.getDimension().y() < this.screen.tabArea.top() || this.getDimension().yLimit() > this.screen.tabArea.bottom()) {
                this.removeDropdownWidget();
            }
        }
    }

    public abstract String getString(U var1);

    public Component shortenString(String value) {
        return Component.literal((String)GuiUtils.shortenString(value, this.textRenderer, this.getDimension().width() - 20, "..."));
    }

    protected int getDecorationPadding() {
        return super.getXPadding();
    }

    protected int getDropdownEntryPadding() {
        return 0;
    }

    public void createDropdownWidget() {
        this.dropdownVisible = true;
        this.dropdownWidget = new DropdownWidget<T>(this.dropdownController, this.screen, this.getDimension(), this);
        this.screen.addPopupControllerWidget(this.dropdownWidget);
    }

    public DropdownWidget<T> dropdownWidget() {
        return this.dropdownWidget;
    }

    public boolean isDropdownVisible() {
        return this.dropdownVisible;
    }

    public void removeDropdownWidget() {
        this.ensureValidValue();
        this.screen.clearPopupControllerWidget();
        this.dropdownVisible = false;
        this.dropdownWidget = null;
    }
}

