/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers;

import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public abstract class ControllerWidget<T extends Controller<?>>
extends AbstractWidget {
    protected final T control;
    protected MultiLineLabel wrappedTooltip;
    protected final YACLScreen screen;
    protected boolean focused = false;
    protected boolean hovered = false;
    protected final Component modifiedOptionName;
    protected final String optionNameString;

    public ControllerWidget(T control, YACLScreen screen, Dimension<Integer> dim) {
        super(dim);
        this.control = control;
        this.screen = screen;
        control.option().addListener((opt, pending) -> this.updateTooltip());
        this.updateTooltip();
        this.modifiedOptionName = control.option().name().copy().withStyle(ChatFormatting.ITALIC);
        this.optionNameString = control.option().name().getString().toLowerCase();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.hovered = this.isMouseOver(mouseX, mouseY);
        Component name = this.control.option().changed() ? this.modifiedOptionName : this.control.option().name();
        MutableComponent shortenedName = Component.literal((String)GuiUtils.shortenString(name.getString(), this.textRenderer, this.getDimension().width() - this.getControlWidth() - this.getXPadding() - 7, "...")).setStyle(name.getStyle());
        this.drawButtonRect(graphics, this.getDimension().x(), this.getDimension().y(), this.getDimension().xLimit(), this.getDimension().yLimit(), this.hovered || this.focused, this.isAvailable());
        graphics.drawString(this.textRenderer, (Component)shortenedName, this.getDimension().x() + this.getXPadding(), this.getTextY(), this.getValueColor(), true);
        this.drawValueText(graphics, mouseX, mouseY, delta);
        if (this.isHovered()) {
            this.drawHoveredControl(graphics, mouseX, mouseY, delta);
        }
    }

    protected void drawHoveredControl(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
    }

    protected void drawValueText(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Component valueText = this.getValueText();
        graphics.drawString(this.textRenderer, valueText, this.getDimension().xLimit() - this.textRenderer.width((FormattedText)valueText) - this.getXPadding(), this.getTextY(), this.getValueColor(), true);
    }

    private void updateTooltip() {
        this.wrappedTooltip = MultiLineLabel.create((Font)this.textRenderer, (Component)this.control.option().tooltip(), (int)(this.screen.width / 3 * 2 - 10));
    }

    protected int getControlWidth() {
        return this.isHovered() ? this.getHoveredControlWidth() : this.getUnhoveredControlWidth();
    }

    public boolean isHovered() {
        return this.isAvailable() && (this.hovered || this.focused);
    }

    protected abstract int getHoveredControlWidth();

    protected int getUnhoveredControlWidth() {
        return this.textRenderer.width((FormattedText)this.getValueText());
    }

    protected int getXPadding() {
        return 5;
    }

    protected int getYPadding() {
        return 2;
    }

    protected Component getValueText() {
        return this.control.formatValue();
    }

    protected boolean isAvailable() {
        return this.control.option().available();
    }

    protected int getValueColor() {
        return this.isAvailable() ? -1 : -6250336;
    }

    @Override
    public boolean canReset() {
        return true;
    }

    protected int getTextY() {
        float f = (float)this.getDimension().y().intValue() + (float)this.getDimension().height().intValue() / 2.0f;
        Objects.requireNonNull(this.textRenderer);
        return (int)(f - 9.0f / 2.0f);
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
        return !this.isFocused() ? ComponentPath.leaf((GuiEventListener)this) : null;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    @Override
    public void unfocus() {
        this.focused = false;
    }

    @Override
    public boolean matchesSearch(String query) {
        return this.optionNameString.contains(query.toLowerCase());
    }

    @Override
    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.focused ? NarratableEntry.NarrationPriority.FOCUSED : (this.isHovered() ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE);
    }

    @Override
    public void updateNarration(NarrationElementOutput builder2) {
        builder2.add(NarratedElementType.TITLE, this.control.option().name());
        builder2.add(NarratedElementType.HINT, this.control.option().tooltip());
    }
}

