/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.config.v2.api.autogen;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigField;
import dev.isxander.yacl3.config.v2.api.autogen.CustomDescription;
import dev.isxander.yacl3.config.v2.api.autogen.CustomImage;
import dev.isxander.yacl3.config.v2.api.autogen.CustomName;
import dev.isxander.yacl3.config.v2.api.autogen.OptionAccess;
import dev.isxander.yacl3.config.v2.api.autogen.OptionFactory;
import dev.isxander.yacl3.config.v2.impl.FieldBackedBinding;
import dev.isxander.yacl3.config.v2.impl.autogen.AutoGenUtils;
import dev.isxander.yacl3.config.v2.impl.autogen.EmptyCustomImageFactory;
import dev.isxander.yacl3.config.v2.impl.autogen.YACLAutoGenException;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleOptionFactory<A extends Annotation, T>
implements OptionFactory<A, T> {
    @Override
    public Option<T> createOption(A annotation, ConfigField<T> field, OptionAccess optionAccess) {
        Option<Object> option = Option.createBuilder().name((Component)this.name(annotation, field, optionAccess)).description(v -> this.description(v, annotation, field, optionAccess).build()).binding(new FieldBackedBinding<T>(field.access(), field.defaultAccess())).controller(opt -> {
            ControllerBuilder<T> builder2 = this.createController(annotation, field, optionAccess, (Option<T>)opt);
            AutoGenUtils.addCustomFormatterToController(builder2, field.access());
            return builder2;
        }).available(this.available(annotation, field, optionAccess)).flags(this.flags(annotation, field, optionAccess)).addListener((opt, event) -> this.listener(annotation, field, optionAccess, opt, opt.pendingValue())).build();
        this.postInit(annotation, field, optionAccess, option);
        return option;
    }

    protected abstract ControllerBuilder<T> createController(A var1, ConfigField<T> var2, OptionAccess var3, Option<T> var4);

    protected MutableComponent name(A annotation, ConfigField<T> field, OptionAccess storage) {
        Optional<CustomName> customName = field.access().getAnnotation(CustomName.class);
        return Component.translatable((String)customName.map(CustomName::value).orElse(this.getTranslationKey(field, null)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OptionDescription.Builder description(T value, A annotation, ConfigField<T> field, OptionAccess storage) {
        OptionDescription.Builder builder2 = OptionDescription.createBuilder();
        Object key = this.getTranslationKey(field, "desc");
        if (Language.getInstance().has((String)key)) {
            builder2.text(new Component[]{Component.translatable((String)key)});
        } else {
            key = (String)key + ".";
            int i = 1;
            while (Language.getInstance().has((String)key + i)) {
                builder2.text(new Component[]{Component.translatable((String)((String)key + i))});
                ++i;
            }
        }
        field.access().getAnnotation(CustomDescription.class).ifPresent(customDescription -> {
            for (String line : customDescription.value()) {
                builder2.text(new Component[]{Component.translatable((String)line)});
            }
        });
        Optional<CustomImage> imageOverrideOpt = field.access().getAnnotation(CustomImage.class);
        if (imageOverrideOpt.isPresent()) {
            String extension;
            CustomImage imageOverride = imageOverrideOpt.get();
            if (!imageOverride.factory().equals(EmptyCustomImageFactory.class)) {
                CustomImage.CustomImageFactory<?> imageFactory;
                try {
                    imageFactory = AutoGenUtils.constructNoArgsClass(imageOverride.factory(), () -> "'%s': The factory class on @OverrideImage has no no-args constructor.".formatted(field.access().name()), () -> "'%s': Failed to instantiate factory class %s.".formatted(field.access().name(), imageOverride.factory().getName()));
                }
                catch (ClassCastException e) {
                    throw new YACLAutoGenException("'%s': The factory class on @OverrideImage is of incorrect type. Expected %s, got %s.".formatted(field.access().name(), field.access().type().getTypeName(), imageOverride.factory().getTypeParameters()[0].getName()));
                }
                builder2.customImage((CompletableFuture<Optional<ImageRenderer>>)imageFactory.createImage(value, field, storage).thenApply(Optional::of));
                return builder2;
            }
            if (imageOverride.value().isEmpty()) throw new YACLAutoGenException("'%s': @OverrideImage has no value or factory class.".formatted(field.access().name()));
            String path = imageOverride.value();
            ResourceLocation imageLocation = YACLPlatform.rl(field.parent().id().getNamespace(), path);
            switch (extension = path.substring(path.lastIndexOf(46) + 1)) {
                case "png": 
                case "jpg": 
                case "jpeg": {
                    builder2.image(imageLocation, imageOverride.width(), imageOverride.height());
                    return builder2;
                }
                case "webp": {
                    builder2.webpImage(imageLocation);
                    return builder2;
                }
                case "gif": {
                    builder2.gifImage(imageLocation);
                    return builder2;
                }
                default: {
                    throw new YACLAutoGenException("'%s': Invalid image extension '%s' on @OverrideImage. Expected: ('png','jpg','webp','gif')".formatted(field.access().name(), extension));
                }
            }
        }
        Object imagePath = "textures/yacl3/" + field.parent().id().getPath() + "/" + field.access().name() + ".webp";
        imagePath = ((String)imagePath).toLowerCase().replaceAll("[^a-z0-9/._:-]", "_");
        ResourceLocation imageLocation = YACLPlatform.rl(field.parent().id().getNamespace(), (String)imagePath);
        if (!Minecraft.getInstance().getResourceManager().getResource(imageLocation).isPresent()) return builder2;
        builder2.webpImage(imageLocation);
        return builder2;
    }

    protected boolean available(A annotation, ConfigField<T> field, OptionAccess storage) {
        return true;
    }

    protected Set<OptionFlag> flags(A annotation, ConfigField<T> field, OptionAccess storage) {
        return Set.of();
    }

    protected void listener(A annotation, ConfigField<T> field, OptionAccess storage, Option<T> option, T value) {
    }

    protected void postInit(A annotation, ConfigField<T> field, OptionAccess storage, Option<T> option) {
    }

    protected String getTranslationKey(ConfigField<T> field, @Nullable String suffix) {
        Object key = "yacl3.config.%s.%s".formatted(field.parent().id().toString(), field.access().name());
        if (suffix != null) {
            key = (String)key + "." + suffix;
        }
        return key;
    }
}

