/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ice;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.icicle.IcicleProjectile;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class FrostbiteSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("irons_spellbooks", "frostbite");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(5).setCooldownSeconds(0.0).build();

    @Override
    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.percent_damage", (Object[])new Object[]{Utils.stringTruncation(this.getPercentDamage(spellLevel, caster) * 100.0f, 1)}));
    }

    public FrostbiteSpell() {
        this.manaCostPerLevel = 50;
        this.baseSpellPower = 75;
        this.spellPowerPerLevel = 15;
        this.castTime = 40;
        this.baseManaCost = 100;
    }

    @Override
    public CastType getCastType() {
        return CastType.LONG;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper(level, entity, playerMagicData, this, 48, 0.15f);
    }

    @Override
    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        TargetEntityCastData targetingData;
        LivingEntity target;
        ICastData iCastData;
        if (playerMagicData != null && (iCastData = playerMagicData.getAdditionalCastData()) instanceof TargetEntityCastData && (target = (targetingData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            float i = playerMagicData.getCastCompletionPercent();
            float f = entity.tickCount;
            float distance = entity.distanceTo((Entity)target);
            float density = 2.0f;
            Vec3 start = target.position().add(0.0, (double)(entity.getBbHeight() * 0.5f), 0.0);
            Vec3 delta = entity.position().subtract(target.position()).normalize();
            start = start.add(delta.scale((double)(i * distance)));
            MagicManager.spawnParticles(level, ParticleHelper.SNOWFLAKE, start.x + (double)(this.beamNoise((f + i + 50.0f) * 1.25f) * 0.25f), start.y + (double)(this.beamNoise((f + i) * 1.5f) * 0.25f), start.z + (double)(this.beamNoise((f + i + 84.0f) * 1.25f) * 0.25f), 1, 0.0, 0.0, 0.0, 0.0, false);
        }
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    private float beamNoise(float f) {
        return (Mth.cos((float)((f %= 360.0f) * 0.25f)) * 2.0f + Mth.sin((float)f) + Mth.cos((float)(2.0f * f)) * 0.25f) * 0.4f;
    }

    @Override
    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetEntityCastData targetingData;
        LivingEntity target;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (target = (targetingData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            float damage = this.getPercentDamage(spellLevel, entity) * (float)target.getTicksFrozen() / 20.0f;
            DamageSources.applyDamage((Entity)target, damage, this.getDamageSource((Entity)entity));
            target.setTicksFrozen(0);
            MagicManager.spawnParticles(level, ParticleHelper.SNOWFLAKE, target.getX(), target.getY() + (double)(target.getBbHeight() * 0.5f), target.getZ(), 35, target.getBbWidth() * 0.5f, target.getBbHeight() * 0.5f, target.getBbWidth() * 0.5f, 0.03, false);
            if (target.isDeadOrDying()) {
                this.spawnIcicleShards(target.getBoundingBox().getCenter(), damage, entity);
                target.discard();
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnIcicleShards(Vec3 origin, float damage, LivingEntity owner) {
        int count = 8;
        int offset = 360 / count;
        for (int i = 0; i < count; ++i) {
            Vec3 motion = new Vec3(0.0, 0.0, 0.55);
            motion = motion.xRot(0.5235988f);
            motion = motion.yRot((float)(offset * i) * ((float)Math.PI / 180));
            IcicleProjectile shard = new IcicleProjectile(owner.level, owner);
            shard.setDamage(damage / (float)count);
            shard.setDeltaMovement(motion);
            Vec3 spawn = origin.add(motion.multiply(1.0, 0.0, 1.0).normalize().scale(0.5));
            Vec2 angle = Utils.rotationFromDirection(motion);
            shard.moveTo(spawn.x, spawn.y - shard.getBoundingBox().getYsize() / 2.0, spawn.z, angle.y, angle.x);
            owner.level.addFreshEntity((Entity)shard);
        }
    }

    public float getPercentDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 0.01f;
    }
}

