/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.setup;

import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronInteraction;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronTile;
import io.redspace.ironsspellbooks.capabilities.magic.MagicEvents;
import io.redspace.ironsspellbooks.compat.CompatHandler;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ModSetup {
    public static void setup() {
        IEventBus bus = NeoForge.EVENT_BUS;
        bus.addListener(MagicEvents::onWorldTick);
    }

    public static void init(FMLCommonSetupEvent event) {
        CompatHandler.init();
        event.enqueueWork(() -> {
            for (Map.Entry entry : AlchemistCauldronTile.INTERACTIONS.entrySet()) {
                final Item item = (Item)entry.getKey();
                DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){
                    private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
                    final Optional<DispenseItemBehavior> oldBehavior = DispenserBlock.DISPENSER_REGISTRY.containsKey(item) ? Optional.of((DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(item)) : Optional.empty();

                    private ItemStack takeLiquid(BlockSource p_123447_, ItemStack p_123448_, ItemStack p_123449_) {
                        p_123448_.shrink(1);
                        if (p_123448_.isEmpty()) {
                            p_123447_.level().gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, p_123447_.pos());
                            return p_123449_.copy();
                        }
                        if (p_123447_.blockEntity().insertItem(p_123449_.copy()).getCount() < 0) {
                            this.defaultDispenseItemBehavior.dispense(p_123447_, p_123449_.copy());
                        }
                        return p_123448_;
                    }

                    public ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
                        this.setSuccess(false);
                        ServerLevel serverlevel = blockSource.level();
                        BlockPos blockpos = blockSource.pos().relative((Direction)blockSource.blockEntity().getBlockState().getValue((Property)DispenserBlock.FACING));
                        BlockState blockstate = serverlevel.getBlockState(blockpos);
                        BlockEntity blockEntity = serverlevel.getBlockEntity(blockpos);
                        if (blockEntity instanceof AlchemistCauldronTile) {
                            AlchemistCauldronTile cauldron = (AlchemistCauldronTile)blockEntity;
                            ItemStack resultStack = ((AlchemistCauldronInteraction)AlchemistCauldronTile.INTERACTIONS.get((Object)itemStack.getItem())).interact(cauldron, blockstate, (Level)serverlevel, blockpos, itemStack);
                            if (resultStack != null) {
                                this.setSuccess(true);
                                cauldron.setChanged();
                                return this.takeLiquid(blockSource, itemStack, resultStack);
                            }
                        }
                        return this.oldBehavior.map(behavior -> behavior.dispense(blockSource, itemStack)).orElse(itemStack);
                    }
                });
            }
        });
    }
}

