/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.events.SpellTeleportEvent;
import io.redspace.ironsspellbooks.api.item.UpgradeData;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.block.BloodCauldronBlock;
import io.redspace.ironsspellbooks.capabilities.magic.CooldownInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.compat.tetra.TetraProxy;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.data.IronsDataStorage;
import io.redspace.ironsspellbooks.datagen.DamageTypeTagGenerator;
import io.redspace.ironsspellbooks.effect.AbyssalShroudEffect;
import io.redspace.ironsspellbooks.effect.EvasionEffect;
import io.redspace.ironsspellbooks.effect.IMobEffectEndCallback;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.spells.root.PreventDismount;
import io.redspace.ironsspellbooks.item.CastingItem;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.network.EquipmentChangedPacket;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import io.redspace.ironsspellbooks.util.ModTags;
import io.redspace.ironsspellbooks.util.UpgradeUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.event.CurioChangeEvent;

@EventBusSubscriber
public class ServerPlayerEvents {
    @SubscribeEvent
    public static void onUseItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.level.isClientSide) {
            MinecraftInstanceHelper.ifPlayerPresent(localPlayer -> {
                if (ClientMagicData.isCasting() && player.getUUID().equals(localPlayer.getUUID())) {
                    event.setCanceled(true);
                }
            });
        } else {
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)player);
            if (magicData.isCasting() && event.getItemStack() != magicData.getPlayerCastingItem()) {
                event.setCanceled(true);
            }
        }
        if (event.isCanceled()) {
            return;
        }
        Level level = player.level;
        InteractionHand hand = event.getHand();
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.has(ComponentRegistry.CASTING_IMPLEMENT)) {
            String castingSlot;
            SpellSelectionManager spellSelectionManager = new SpellSelectionManager(player);
            SpellSelectionManager.SelectionOption selectionOption = spellSelectionManager.getSelection();
            if (selectionOption == null || selectionOption.spellData.equals(SpellData.EMPTY)) {
                return;
            }
            SpellData spellData = selectionOption.spellData;
            int spellLevel = spellData.getSpell().getLevelFor(spellData.getLevel(), (LivingEntity)player);
            if (level.isClientSide()) {
                if (ClientMagicData.isCasting()) {
                    event.setCancellationResult(InteractionResult.CONSUME);
                } else {
                    if (ClientMagicData.getPlayerMana() < spellData.getSpell().getManaCost(spellLevel) || ClientMagicData.getCooldowns().isOnCooldown(spellData.getSpell()) || !ClientMagicData.getSyncedSpellData((LivingEntity)player).isSpellLearned(spellData.getSpell())) {
                        return;
                    }
                    event.setCancellationResult(InteractionResult.CONSUME);
                }
            }
            String string = castingSlot = hand.ordinal() == 0 ? SpellSelectionManager.MAINHAND : SpellSelectionManager.OFFHAND;
            if (spellData.getSpell().attemptInitiateCast(itemStack, spellLevel, level, player, selectionOption.getCastSource(), true, castingSlot)) {
                event.setCancellationResult(InteractionResult.CONSUME);
            } else {
                event.setCancellationResult(InteractionResult.FAIL);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerDropItem(ItemTossEvent event) {
        MagicData magicData;
        ItemStack itemStack = event.getEntity().getItem();
        if (itemStack.getItem() instanceof Scroll && (magicData = MagicData.getPlayerMagicData((LivingEntity)event.getPlayer())).isCasting() && magicData.getCastSource() == CastSource.SCROLL && magicData.getCastType() == CastType.CONTINUOUS) {
            itemStack.shrink(1);
        }
    }

    @SubscribeEvent
    public static void onLevelLoaded(LevelEvent.Load event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).dimension() == Level.OVERWORLD) {
            IronsDataStorage.init(serverLevel.getDataStorage());
        }
    }

    @SubscribeEvent
    public static void onServerStoppedEvent(ServerStoppedEvent event) {
        IronsSpellbooks.MCS = null;
        IronsSpellbooks.OVERWORLD = null;
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        IronsSpellbooks.MCS = event.getServer();
        IronsSpellbooks.OVERWORLD = IronsSpellbooks.MCS.overworld();
    }

    @SubscribeEvent
    public static void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            if (playerMagicData.isCasting() && (event.getFrom().getItem() instanceof CastingItem || event.getTo().getItem() instanceof CastingItem)) {
                Utils.serverSideCancelCast(serverPlayer);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new EquipmentChangedPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            boolean isFromSpellContainer = ISpellContainer.isSpellContainer(event.getFrom());
            if (isFromSpellContainer && ISpellContainer.get(event.getFrom()).getIndexForSpell(playerMagicData.getCastingSpell().getSpell()) >= 0) {
                IronsSpellbooks.LOGGER.debug("onLivingEquipmentChangeEvent from:\n{}\n{}", (Object)event.getFrom().toString(), (Object)Integer.toHexString(event.getFrom().hashCode()));
                IronsSpellbooks.LOGGER.debug("onLivingEquipmentChangeEvent to:\n{}\n{}", (Object)event.getTo().toString(), (Object)Integer.toHexString(event.getTo().hashCode()));
                if (playerMagicData.isCasting()) {
                    Utils.serverSideCancelCast(serverPlayer);
                }
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new EquipmentChangedPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (isFromSpellContainer || ISpellContainer.isSpellContainer(event.getTo())) {
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new EquipmentChangedPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onCurioChangeEvent(CurioChangeEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (ISpellContainer.isSpellContainer(event.getFrom()) || ISpellContainer.isSpellContainer(event.getTo())) {
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new EquipmentChangedPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerOpenContainer(PlayerContainerEvent.Open event) {
        ServerPlayer serverPlayer;
        MagicData playerMagicData;
        if (event.getEntity().level.isClientSide) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (playerMagicData = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)player))).isCasting()) {
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void handleUpgradeModifiers(ItemAttributeModifierEvent event) {
        UpgradeData upgradeData = UpgradeData.getUpgradeData(event.getItemStack());
        if (upgradeData != UpgradeData.NONE) {
            try {
                EquipmentSlot equipmentSlot = EquipmentSlot.byName((String)upgradeData.getUpgradedSlot());
                EquipmentSlotGroup groupSlot = EquipmentSlotGroup.bySlot((EquipmentSlot)equipmentSlot);
                UpgradeUtils.handleAttributeEvent(event.getModifiers(), upgradeData, (atr, mod) -> event.addModifier(atr, mod, groupSlot), (atr, mod) -> event.removeModifier(atr, mod.id()), upgradeData.getUpgradedSlot());
            }
            catch (IllegalArgumentException e) {
                return;
            }
        }
    }

    @SubscribeEvent
    public static void handleCurioUpgradeModifiers(CurioAttributeModifierEvent event) {
        UpgradeData upgradeData = UpgradeData.getUpgradeData(event.getItemStack());
        if (upgradeData != UpgradeData.NONE && upgradeData.getUpgradedSlot().equals(event.getSlotContext().identifier())) {
            List<ItemAttributeModifiers.Entry> list = event.getModifiers().entries().stream().map(entry -> new ItemAttributeModifiers.Entry((Holder)entry.getKey(), (AttributeModifier)entry.getValue(), EquipmentSlotGroup.ANY)).toList();
            UpgradeUtils.handleAttributeEvent(list, upgradeData, (arg_0, arg_1) -> ((CurioAttributeModifierEvent)event).addModifier(arg_0, arg_1), (arg_0, arg_1) -> ((CurioAttributeModifierEvent)event).removeModifier(arg_0, arg_1), event.getSlotContext().identifier());
        }
    }

    @SubscribeEvent
    public static void onExperienceDroppedEvent(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player != null) {
            int ringCount = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.findCurios((Item)ItemRegistry.EMERALD_STONEPLATE_RING.get()).size()).orElse(0);
            for (int i = 0; i < ringCount; ++i) {
                event.setDroppedExperience((int)((double)event.getDroppedExperience() * 1.25));
            }
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof ServerPlayer) {
                ServerPlayer targetPlayer = (ServerPlayer)player;
                MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getSyncedData().syncToPlayer(targetPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            playerMagicData.getPlayerCooldowns().syncToPlayer(serverPlayer);
            playerMagicData.getPlayerRecasts().syncAllToPlayer();
            playerMagicData.getSyncedData().syncToPlayer(serverPlayer);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncManaPacket(playerMagicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
            CameraShakeManager.doSync(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            Utils.serverSideCancelCast(serverPlayer);
            MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerRecasts().removeAll(RecastResult.DEATH);
            serverPlayer.getActiveEffects().forEach(mobEffectInstance -> {
                Object patt0$temp = mobEffectInstance.getEffect().value();
                if (patt0$temp instanceof IMobEffectEndCallback) {
                    IMobEffectEndCallback callback = (IMobEffectEndCallback)patt0$temp;
                    callback.onEffectRemoved((LivingEntity)serverPlayer, mobEffectInstance.getAmplifier());
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSpellTeleport(SpellTeleportEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (ItemRegistry.TELEPORTATION_AMULET.get().isEquippedBy(livingEntity)) {
                livingEntity.addEffect(new MobEffectInstance(MobEffectRegistry.EVASION, 60, 0, false, false, true));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer newServerPlayer = (ServerPlayer)player;
            if (event.isWasDeath()) {
                event.getOriginal().getActiveEffects().forEach(effect -> {
                    if (effect.getEffect() instanceof SummonTimer) {
                        newServerPlayer.addEffect(effect, (Entity)newServerPlayer);
                    }
                });
                IronsSpellbooks.LOGGER.debug("onPlayerCloned: copy data: client: {}", (Object)newServerPlayer.level.isClientSide);
                MagicData oldMagicData = MagicData.getPlayerMagicData((LivingEntity)event.getOriginal());
                MagicData newMagicData = MagicData.getPlayerMagicData((LivingEntity)newServerPlayer);
                newMagicData.setSyncedData(oldMagicData.getSyncedData().getPersistentData(newServerPlayer));
                oldMagicData.getPlayerCooldowns().getSpellCooldowns().forEach((spellId, cooldown) -> newMagicData.getPlayerCooldowns().getSpellCooldowns().put((String)spellId, (CooldownInstance)cooldown));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.clearFire();
            serverPlayer.setTicksFrozen(0);
            List data = serverPlayer.getEntityData().packDirty();
            if (data != null) {
                serverPlayer.connection.send((Packet)new ClientboundSetEntityDataPacket(serverPlayer.getId(), data));
            }
            Utils.serverSideCancelCast(serverPlayer);
            serverPlayer.getActiveEffects().forEach(effect -> {
                if (effect.getEffect() instanceof SummonTimer) {
                    serverPlayer.server.getPlayerList().sendActivePlayerEffects(serverPlayer);
                }
            });
            MagicData.getPlayerMagicData((LivingEntity)serverPlayer).setMana((int)(serverPlayer.getAttributeValue(AttributeRegistry.MAX_MANA) * (Double)ServerConfigs.MANA_SPAWN_PERCENT.get()));
        }
    }

    @SubscribeEvent
    public static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
        Creeper creeper;
        LivingEntity livingEntity;
        LivingEntity livingEntity2 = event.getEntity();
        if (livingEntity2 instanceof ServerPlayer || livingEntity2 instanceof IMagicEntity) {
            if (ItemRegistry.FIREWARD_RING.get().isEquippedBy(livingEntity2) && event.getSource().is(DamageTypeTags.IS_FIRE)) {
                event.getEntity().clearFire();
                event.setCanceled(true);
                return;
            }
            MagicData playerMagicData = MagicData.getPlayerMagicData(livingEntity2);
            if (playerMagicData.getSyncedData().hasEffect(2L)) {
                if (EvasionEffect.doEffect(livingEntity2, event.getSource())) {
                    event.setCanceled(true);
                    return;
                }
            } else if (playerMagicData.getSyncedData().hasEffect(8L) && AbyssalShroudEffect.doEffect(livingEntity2, event.getSource())) {
                event.setCanceled(true);
                return;
            }
            if (livingEntity2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
                if (playerMagicData.isCasting() && playerMagicData.getCastingSpell().getSpell().canBeInterrupted((Player)serverPlayer) && playerMagicData.getCastDurationRemaining() > 0 && !event.getSource().is(DamageTypeTagGenerator.LONG_CAST_IGNORE) && !playerMagicData.popMarkedPoison()) {
                    Utils.serverSideCancelCast(serverPlayer);
                }
            }
        }
        if (((Boolean)ServerConfigs.BETTER_CREEPER_THUNDERHIT.get()).booleanValue() && event.getSource().is(DamageTypeTags.IS_FIRE) && (livingEntity = event.getEntity()) instanceof Creeper && (creeper = (Creeper)livingEntity).isPowered()) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onBeforeDamageTaken(LivingDamageEvent.Pre event) {
        MagicData playerMagicData;
        LivingEntity livingEntity = event.getEntity();
        if ((livingEntity instanceof IMagicEntity || livingEntity instanceof ServerPlayer) && (playerMagicData = MagicData.getPlayerMagicData(livingEntity)).getSyncedData().hasEffect(4L)) {
            playerMagicData.getSyncedData().addHeartstopDamage(event.getOriginalDamage() * 0.5f);
            event.setNewDamage(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity newTarget = event.getNewAboutToBeSetTarget();
        LivingEntity entity = event.getEntity();
        if (newTarget != null) {
            if (newTarget.getType().is(ModTags.VILLAGE_ALLIES) && entity.getType().is(ModTags.VILLAGE_ALLIES)) {
                event.setCanceled(true);
                return;
            }
            if (newTarget instanceof IMagicSummon) {
                IMagicSummon summon = (IMagicSummon)newTarget;
                if (!entity.equals((Object)((Mob)newTarget).getTarget())) {
                    event.setCanceled(true);
                    return;
                }
            }
            if (newTarget.hasEffect(MobEffectRegistry.TRUE_INVISIBILITY)) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamagePost(LivingDamageEvent.Post event) {
        TetraProxy.PROXY.handleLivingAttackEvent(event);
    }

    @SubscribeEvent
    public static void onEntityMountEvent(EntityMountEvent event) {
        ServerPlayer serverPlayer;
        MagicData playerMagicData;
        if (event.getEntity().level.isClientSide) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (playerMagicData = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)entity))).isCasting()) {
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void preventDismount(EntityMountEvent event) {
        if (!event.getEntity().level.isClientSide && event.getEntityBeingMounted() instanceof PreventDismount && event.isDismounting() && !event.getEntityBeingMounted().isRemoved()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        EntityHitResult entityHitResult;
        Entity victim;
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && ((victim = (entityHitResult = (EntityHitResult)hitResult).getEntity()) instanceof IMagicEntity || victim instanceof Player)) {
            SyncedSpellData syncedSpellData;
            LivingEntity livingEntity = (LivingEntity)victim;
            SyncedSpellData syncedSpellData2 = syncedSpellData = livingEntity.level.isClientSide ? ClientMagicData.getSyncedSpellData(livingEntity) : MagicData.getPlayerMagicData(livingEntity).getSyncedData();
            if (syncedSpellData.hasEffect(2L)) {
                if (EvasionEffect.doEffect(livingEntity, victim.damageSources().indirectMagic((Entity)event.getProjectile(), event.getProjectile().getOwner()))) {
                    event.setCanceled(true);
                }
            } else if (syncedSpellData.hasEffect(8L) && AbyssalShroudEffect.doEffect(livingEntity, victim.damageSources().indirectMagic((Entity)event.getProjectile(), event.getProjectile().getOwner()))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void useOnEntityEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            Player player = event.getEntity();
            ItemStack useItem = player.getItemInHand(event.getHand());
            if (useItem.is(Items.GLASS_BOTTLE) && creeper.isPowered()) {
                creeper.hurt(creeper.damageSources().generic(), 5.0f);
                player.level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL_DRAGONBREATH, SoundSource.NEUTRAL, 1.0f, 1.0f);
                player.swing(event.getHand());
                event.setCancellationResult(InteractionResultHolder.consume((Object)ItemUtils.createFilledResult((ItemStack)useItem, (Player)player, (ItemStack)new ItemStack((ItemLike)ItemRegistry.LIGHTNING_BOTTLE.get()))).getResult());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void handleResistanceAttributesOnSpawn(FinalizeSpawnEvent event) {
        Mob mob = event.getEntity();
        if (mob.getType().is(EntityTypeTags.UNDEAD)) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, AttributeRegistry.HOLY_MAGIC_RESIST, 0.5);
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, AttributeRegistry.BLOOD_MAGIC_RESIST, 1.5);
        } else if (mob.getType().is(EntityTypeTags.SENSITIVE_TO_IMPALING)) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, AttributeRegistry.LIGHTNING_MAGIC_RESIST, 0.5);
        }
        if (mob.fireImmune()) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, AttributeRegistry.FIRE_MAGIC_RESIST, 1.5);
        }
        if (mob.getType() == EntityType.BLAZE) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, AttributeRegistry.ICE_MAGIC_RESIST, 0.5);
        }
    }

    private static void setIfNonNull(LivingEntity mob, Holder<Attribute> attribute, double value) {
        AttributeInstance instance = mob.getAttributes().getInstance(attribute);
        if (instance != null) {
            instance.setBaseValue(value);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Pre event) {
        BlockPos pos;
        BlockState blockState;
        Entity entity = event.getEntity();
        Level level = entity.level;
        if (!level.isClientSide && entity.tickCount % 40 == 0 && (blockState = entity.level.getBlockState(pos = entity.blockPosition())).is(Blocks.CAULDRON)) {
            BloodCauldronBlock.attemptCookEntity(blockState, entity.level, pos, entity, () -> {
                level.setBlockAndUpdate(pos, ((Block)BlockRegistry.BLOOD_CAULDRON_BLOCK.get()).defaultBlockState());
                level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            });
        }
    }

    @SubscribeEvent
    public static void onAnvilRecipe(AnvilUpdateEvent event) {
        ItemStack result;
        if (event.getRight().is((Item)ItemRegistry.SHRIVING_STONE.get()) && !(result = Utils.handleShriving(event.getLeft())).isEmpty()) {
            String itemName = event.getName();
            if (itemName != null && !StringUtil.isBlank((String)itemName)) {
                if (!itemName.equals(result.getHoverName().getString())) {
                    result.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)itemName));
                }
            } else if (result.has(DataComponents.CUSTOM_NAME)) {
                result.remove(DataComponents.CUSTOM_NAME);
            }
            event.setOutput(result);
            event.setCost(1L);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent
    public static void changeDigSpeed(PlayerEvent.BreakSpeed event) {
        int i;
        Player player = event.getEntity();
        if (player.hasEffect(MobEffectRegistry.HASTENED)) {
            i = 1 + player.getEffect(MobEffectRegistry.HASTENED).getAmplifier();
            event.setNewSpeed(event.getNewSpeed() * Utils.intPow(1.2f, i));
        }
        if (player.hasEffect(MobEffectRegistry.SLOWED)) {
            i = 1 + player.getEffect(MobEffectRegistry.SLOWED).getAmplifier();
            event.setNewSpeed(event.getNewSpeed() * Utils.intPow(0.8f, i));
        }
    }

    @SubscribeEvent
    public static void changeBreedOutcome(BabyEntitySpawnEvent event) {
        AgeableMob ageableMob;
        if (((Boolean)ServerConfigs.HOGLIN_OFFSPRING_PROTECTION.get()).booleanValue() && (ageableMob = event.getChild()) instanceof Hoglin) {
            Hoglin baby = (Hoglin)ageableMob;
            ageableMob = event.getParentA();
            if (ageableMob instanceof Hoglin) {
                Hoglin parent1 = (Hoglin)ageableMob;
                ageableMob = event.getParentB();
                if (ageableMob instanceof Hoglin) {
                    Hoglin parent2 = (Hoglin)ageableMob;
                    double i = (parent1.isImmuneToZombification() ? 0.5 : 0.0) + (parent2.isImmuneToZombification() ? 0.5 : 0.0);
                    if ((double)Utils.random.nextFloat() < i) {
                        baby.setImmuneToZombification(true);
                    }
                }
            }
        }
    }
}

