/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.particle;

import io.redspace.ironsspellbooks.particle.SparkParticleOptions;
import io.redspace.ironsspellbooks.particle.ZapParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SparkParticle
extends TextureSheetParticle {
    boolean touchedGround;
    float bounciness;

    public SparkParticle(SparkParticleOptions options, ClientLevel level, double xCoord, double yCoord, double zCoord, double xd, double yd, double zd) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.scale(this.random.nextFloat() * 0.65f + 0.4f);
        this.lifetime = 20 + (int)(Math.random() * 45.0);
        this.gravity = 1.3f;
        this.friction = 0.985f;
        this.quadSize = 0.0625f;
        this.rCol = options.color.x() * (0.9f + this.random.nextFloat() * 0.1f);
        this.gCol = options.color.y() * (0.9f + this.random.nextFloat() * 0.1f);
        this.bCol = options.color.z() * (0.9f + this.random.nextFloat() * 0.1f);
        this.bounciness = 0.6f + this.random.nextFloat() * 0.2f;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
    }

    public void tick() {
        if (!this.touchedGround && this.lifetime < 80) {
            ++this.lifetime;
        }
        if (this.onGround) {
            this.touchedGround = true;
            this.yd *= (double)(-this.bounciness);
            this.bounciness *= 0.8f;
            this.quadSize *= 0.9f;
        }
        super.tick();
        Vec3 vec3 = new Vec3(this.x - this.xo, this.y - this.yo, this.z - this.zo);
        if (vec3.lengthSqr() < 0.001) {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ZapParticle.PARTICLE_EMISSIVE;
    }

    public int getLightColor(float p_107564_) {
        return 0xF000F0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SparkParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@NotNull SparkParticleOptions options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            SparkParticle particle = new SparkParticle(options, level, x, y, z, dx, dy, dz);
            particle.pickSprite(this.sprites);
            return particle;
        }
    }
}

