/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.effect.IMobEffectEndCallback;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private static final List<EquipmentSlot> handSlots = List.of(EquipmentSlot.OFFHAND, EquipmentSlot.MAINHAND);

    @Inject(method={"onEffectRemoved"}, at={@At(value="HEAD")})
    public void onEffectRemoved(MobEffectInstance pEffectInstance, CallbackInfo ci) {
        Object object;
        LivingEntity self = (LivingEntity)this;
        if (!self.level.isClientSide && (object = pEffectInstance.getEffect().value()) instanceof IMobEffectEndCallback) {
            IMobEffectEndCallback mobEffect = (IMobEffectEndCallback)object;
            mobEffect.onEffectRemoved(self, pEffectInstance.getAmplifier());
        }
    }

    @Inject(method={"updateInvisibilityStatus"}, at={@At(value="TAIL")})
    public void updateInvisibilityStatus(CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (self.hasEffect(MobEffectRegistry.TRUE_INVISIBILITY)) {
            self.setInvisible(true);
        }
    }

    @Inject(method={"isCurrentlyGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    public void isCurrentlyGlowing(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self = (LivingEntity)this;
        if (!self.level.isClientSide() && self.hasEffect(MobEffectRegistry.GUIDING_BOLT)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Shadow
    abstract ItemStack getLastHandItem(EquipmentSlot var1);

    @Inject(method={"collectEquipmentChanges"}, at={@At(value="RETURN")})
    public void handleEquipmentChanges(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> cir) {
        ItemStack offhandStack;
        Map changedEquipment = (Map)cir.getReturnValue();
        if (changedEquipment == null) {
            return;
        }
        LivingEntity self = (LivingEntity)this;
        ItemStack toStack = (ItemStack)changedEquipment.get(EquipmentSlot.MAINHAND);
        if (toStack == null) {
            return;
        }
        ItemStack fromStack = this.getLastHandItem(EquipmentSlot.MAINHAND);
        if (fromStack == (offhandStack = self.getOffhandItem())) {
            return;
        }
        if (!offhandStack.isEmpty() && offhandStack.has(ComponentRegistry.MULTIHAND_WEAPON)) {
            if (toStack.has(ComponentRegistry.MULTIHAND_WEAPON)) {
                if (!toStack.isEmpty()) {
                    self.getAttributes().removeAttributeModifiers(LivingEntityMixin.filterApplicableAttributes(offhandStack.getAttributeModifiers()));
                }
            } else if (fromStack.has(ComponentRegistry.MULTIHAND_WEAPON) && !offhandStack.isEmpty()) {
                self.getAttributes().addTransientAttributeModifiers(LivingEntityMixin.filterApplicableAttributes(offhandStack.getAttributeModifiers()));
            }
        }
    }

    @Unique
    private static Multimap<Holder<Attribute>, AttributeModifier> filterApplicableAttributes(ItemAttributeModifiers modifiers) {
        List<ItemAttributeModifiers.Entry> list = modifiers.modifiers().stream().filter(entry -> entry.slot() == EquipmentSlotGroup.MAINHAND).toList();
        HashMultimap map = HashMultimap.create();
        for (ItemAttributeModifiers.Entry entry2 : list) {
            Predicate<Holder<Attribute>> predicate = (Boolean)ServerConfigs.APPLY_ALL_MULTIHAND_ATTRIBUTES.get() != false ? Utils.NON_BASE_ATTRIBUTES : Utils.ONLY_MAGIC_ATTRIBUTES;
            if (!predicate.test((Holder<Attribute>)entry2.attribute())) continue;
            map.put((Object)entry2.attribute(), (Object)entry2.modifier());
        }
        return map;
    }
}

