/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.loot;

import com.mojang.serialization.Codec;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class SpellFilter {
    SchoolType schoolType = null;
    List<AbstractSpell> spells = new ArrayList<AbstractSpell>();
    static final Cache<List<AbstractSpell>> DEFAULT_SPELLS = new Cache<List>(() -> SpellRegistry.REGISTRY.stream().filter(AbstractSpell::allowLooting).toList());
    static final Cache<Map<SchoolType, List<AbstractSpell>>> SPELLS_FOR_SCHOOL = new Cache<Map>(() -> SchoolRegistry.REGISTRY.stream().collect(Collectors.toMap(school -> school, school -> SpellRegistry.getSpellsForSchool(school).stream().filter(AbstractSpell::allowLooting).toList())));
    private static final Codec<SpellFilter> SCHOOL_CODEC = ResourceLocation.CODEC.fieldOf("school").xmap(resourceLocation -> new SpellFilter(SchoolRegistry.getSchool(resourceLocation)), spellFilter -> spellFilter.schoolType.getId()).codec();
    private static final Codec<SpellFilter> SPELLS_CODEC = Codec.list((Codec)ResourceLocation.CODEC).fieldOf("spells").xmap(resourceLocation -> new SpellFilter(resourceLocation.stream().filter(r -> SpellRegistry.getSpell(r) != null).map(SpellRegistry::getSpell).toList()), spellFilter -> spellFilter.spells.stream().map(AbstractSpell::getSpellResource).toList()).codec();
    private static final Codec<SpellFilter> NO_FILTER_CODEC = Codec.unit((Object)new SpellFilter());
    public static final Codec<SpellFilter> CODEC = Codec.withAlternative(SCHOOL_CODEC, SPELLS_CODEC);

    public SpellFilter(SchoolType schoolType) {
        this.schoolType = schoolType;
    }

    public SpellFilter(List<AbstractSpell> spells) {
        this.spells = spells;
    }

    public SpellFilter() {
    }

    public boolean isFiltered() {
        return this.schoolType != null || !this.spells.isEmpty();
    }

    public List<AbstractSpell> getApplicableSpells() {
        if (!this.spells.isEmpty()) {
            return this.spells;
        }
        if (this.schoolType != null) {
            List<AbstractSpell> spells = SPELLS_FOR_SCHOOL.get().get(this.schoolType);
            if (!spells.isEmpty()) {
                return spells;
            }
        } else {
            List<AbstractSpell> spells = DEFAULT_SPELLS.get();
            if (!spells.isEmpty()) {
                return spells;
            }
        }
        return List.of(SpellRegistry.none());
    }

    public AbstractSpell getRandomSpell(RandomSource random, Predicate<AbstractSpell> filter) {
        List<AbstractSpell> spells = this.getApplicableSpells().stream().filter(filter).toList();
        if (spells.isEmpty()) {
            return SpellRegistry.none();
        }
        return spells.get(random.nextInt(spells.size()));
    }

    public AbstractSpell getRandomSpell(RandomSource randomSource) {
        return this.getRandomSpell(randomSource, spell -> spell.isEnabled() && spell != SpellRegistry.none() && spell.allowLooting());
    }

    static class Cache<T> {
        Supplier<T> supplier;
        T value;

        Cache(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        T get() {
            if (this.value == null) {
                this.value = this.supplier.get();
            }
            return this.value;
        }
    }
}

