/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsspellbooks.item.FurledMapItem;
import io.redspace.ironsspellbooks.registries.LootRegistry;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class FurledMapLootFunction
extends LootItemConditionalFunction {
    private final String destination;
    private final String translation;
    public static final MapCodec<FurledMapLootFunction> CODEC = RecordCodecBuilder.mapCodec(builder -> FurledMapLootFunction.commonFields((RecordCodecBuilder.Instance)builder).and(builder.group((App)Codec.STRING.fieldOf("destination").forGetter(FurledMapLootFunction::getDestination), (App)Codec.STRING.fieldOf("description_translation").forGetter(FurledMapLootFunction::getTranslation))).apply((Applicative)builder, FurledMapLootFunction::new));

    public String getDestination() {
        return this.destination;
    }

    public String getTranslation() {
        return this.translation;
    }

    protected FurledMapLootFunction(List<LootItemCondition> lootConditions, String destination, String translation) {
        super(lootConditions);
        this.destination = destination;
        this.translation = translation;
    }

    protected ItemStack run(ItemStack itemStack, LootContext lootContext) {
        if (itemStack.getItem() instanceof FurledMapItem) {
            return FurledMapItem.of(ResourceLocation.parse((String)this.destination), Component.translatable((String)this.translation));
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return LootRegistry.SET_FURLED_MAP_FUNCTION.get();
    }
}

