/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import io.redspace.ironsspellbooks.registries.CreativeTabRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class VanillaAnvilRecipeMaker {
    public static List<IJeiAnvilRecipe> getAnvilRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        return Stream.concat(VanillaAnvilRecipeMaker.getArmorRepairRecipes(vanillaRecipeFactory), VanillaAnvilRecipeMaker.getItemRepairRecipes(vanillaRecipeFactory)).toList();
    }

    public static Stream<IJeiAnvilRecipe> getItemRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        List<TieredItem> repairableItems = VanillaAnvilRecipeMaker.getTieredItems();
        return repairableItems.stream().mapMulti((item, consumer) -> {
            ItemStack damagedThreeQuarters = new ItemStack((ItemLike)item);
            damagedThreeQuarters.setDamageValue(damagedThreeQuarters.getMaxDamage() * 3 / 4);
            ItemStack damagedHalf = new ItemStack((ItemLike)item);
            damagedHalf.setDamageValue(damagedHalf.getMaxDamage() / 2);
            IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedThreeQuarters), List.of(damagedThreeQuarters), List.of(damagedHalf));
            consumer.accept(repairWithSame);
            List<ItemStack> repairMaterials = Arrays.stream(item.getTier().getRepairIngredient().getItems()).toList();
            ItemStack damagedFully = new ItemStack((ItemLike)item);
            damagedFully.setDamageValue(damagedFully.getMaxDamage());
            IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, List.of(damagedThreeQuarters));
            consumer.accept(repairWithMaterial);
        });
    }

    public static Stream<IJeiAnvilRecipe> getArmorRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        List<ArmorItem> repairableItems = VanillaAnvilRecipeMaker.getArmorItems();
        return repairableItems.stream().mapMulti((item, consumer) -> {
            ItemStack damagedThreeQuarters = new ItemStack((ItemLike)item);
            damagedThreeQuarters.setDamageValue(damagedThreeQuarters.getMaxDamage() * 3 / 4);
            ItemStack damagedHalf = new ItemStack((ItemLike)item);
            damagedHalf.setDamageValue(damagedHalf.getMaxDamage() / 2);
            IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedThreeQuarters), List.of(damagedThreeQuarters), List.of(damagedHalf));
            consumer.accept(repairWithSame);
            List<ItemStack> repairMaterials = Arrays.stream(((Ingredient)((ArmorMaterial)item.getMaterial().value()).repairIngredient().get()).getItems()).toList();
            ItemStack damagedFully = new ItemStack((ItemLike)item);
            damagedFully.setDamageValue(damagedFully.getMaxDamage());
            IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, List.of(damagedThreeQuarters));
            consumer.accept(repairWithMaterial);
        });
    }

    public static List<TieredItem> getTieredItems() {
        Collection registryItems = ((CreativeModeTab)CreativeTabRegistry.EQUIPMENT_TAB.get()).getSearchTabDisplayItems();
        ArrayList<TieredItem> items = new ArrayList<TieredItem>();
        for (ItemStack item : registryItems) {
            Item item2 = item.getItem();
            if (!(item2 instanceof TieredItem)) continue;
            TieredItem tieredItem = (TieredItem)item2;
            items.add(tieredItem);
        }
        return items;
    }

    public static List<ArmorItem> getArmorItems() {
        Collection registryItems = ((CreativeModeTab)CreativeTabRegistry.EQUIPMENT_TAB.get()).getSearchTabDisplayItems();
        ArrayList<ArmorItem> items = new ArrayList<ArmorItem>();
        for (ItemStack item : registryItems) {
            Item item2 = item.getItem();
            if (!(item2 instanceof ArmorItem)) continue;
            ArmorItem tieredItem = (ArmorItem)item2;
            items.add(tieredItem);
        }
        return items;
    }
}

