/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import io.redspace.ironsspellbooks.api.item.UpgradeData;
import io.redspace.ironsspellbooks.api.item.curios.AffinityData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.item.UpgradeOrbItem;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.util.UpgradeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ArcaneAnvilRecipe {
    @NotNull
    Type type;
    @Nullable
    ItemStack leftItem;
    @Nullable
    List<ItemStack> rightItem;
    @Nullable
    AbstractSpell spell;
    @Nullable
    int level;

    public ArcaneAnvilRecipe(ItemStack leftItem, List<ItemStack> rightItem) {
        this.leftItem = leftItem;
        this.rightItem = rightItem;
        this.type = Type.Item_Upgrade;
    }

    public ArcaneAnvilRecipe(ItemStack leftItem, AbstractSpell spell) {
        this.leftItem = leftItem;
        this.spell = spell;
        this.type = Type.Imbue;
    }

    public ArcaneAnvilRecipe(AbstractSpell spell, int baseLevel) {
        this.spell = spell;
        this.level = baseLevel;
        this.type = Type.Scroll_Upgrade;
    }

    public ArcaneAnvilRecipe(AbstractSpell spell) {
        this.spell = spell;
        this.type = Type.Affinity_Ring_Attune;
    }

    public Tuple<List<ItemStack>, List<ItemStack>, List<ItemStack>> getRecipeItems() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ItemStack scroll1 = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
                ItemStack scroll2 = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
                ItemStack ink = new ItemStack((ItemLike)InkItem.getInkForRarity(this.spell.getRarity(this.level + 1)));
                ISpellContainer.createScrollContainer(this.spell, this.level, scroll1);
                ISpellContainer.createScrollContainer(this.spell, this.level + 1, scroll2);
                yield new Tuple<List<ItemStack>, List<ItemStack>, List<ItemStack>>(List.of(scroll1), List.of(ink), List.of(scroll2));
            }
            case 2 -> {
                Tuple<List<ItemStack>, List<ItemStack>, List<ItemStack>> tuple = new Tuple<List<ItemStack>, List<ItemStack>, List<ItemStack>>(new ArrayList(), new ArrayList(), new ArrayList());
                ((List)tuple.a).add(this.leftItem);
                SpellRegistry.getEnabledSpells().forEach(spell -> IntStream.rangeClosed(spell.getMinLevel(), spell.getMaxLevel()).forEach(i -> {
                    ItemStack scroll = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
                    ISpellContainer.createScrollContainer(spell, i, scroll);
                    ItemStack result = this.leftItem.copy();
                    ISpellContainer.createScrollContainer(spell, i, result);
                    ((List)tuple.b).add(scroll);
                    ((List)tuple.c).add(result);
                }));
                yield tuple;
            }
            case 1 -> {
                Tuple tuple = new Tuple(new ArrayList(), new ArrayList(), new ArrayList());
                ((List)tuple.a).add(this.leftItem);
                this.rightItem.forEach(upgradeStack -> {
                    ItemStack result = this.leftItem.copy();
                    result.set(ComponentRegistry.UPGRADE_DATA, (Object)UpgradeData.NONE.addUpgrade(result, ((UpgradeOrbItem)upgradeStack.getItem()).getUpgradeType(), UpgradeUtils.getRelevantEquipmentSlot(this.leftItem)));
                    ((List)tuple.b).add(upgradeStack);
                    ((List)tuple.c).add(result);
                });
                yield tuple;
            }
            case 3 -> {
                Tuple tuple = new Tuple(new ArrayList(), new ArrayList(), new ArrayList());
                ItemStack result = new ItemStack((ItemLike)ItemRegistry.AFFINITY_RING.get());
                result.set(ComponentRegistry.AFFINITY_COMPONENT, (Object)new AffinityData(this.spell.getSpellId(), 1));
                SpellRegistry.getEnabledSpells().forEach(randomSpell -> {
                    ItemStack baseRing = new ItemStack((ItemLike)ItemRegistry.AFFINITY_RING.get());
                    baseRing.set(ComponentRegistry.AFFINITY_COMPONENT, (Object)new AffinityData(randomSpell.getSpellId(), 1));
                    ((List)tuple.a).add(baseRing);
                });
                IntStream.rangeClosed(this.spell.getMinLevel(), this.spell.getMaxLevel()).forEach(i -> {
                    ItemStack scroll = new ItemStack(ItemRegistry.SCROLL);
                    ISpellContainer.createScrollContainer(this.spell, i, scroll);
                    ((List)tuple.b).add(scroll);
                });
                ((List)tuple.c).add(result);
                yield tuple;
            }
        };
    }

    static enum Type {
        Scroll_Upgrade,
        Item_Upgrade,
        Imbue,
        Affinity_Ring_Attune;

    }

    public record Tuple<A, B, C>(A a, B b, C c) {
    }
}

