/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipeRegistry;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.CauldronPlatformHelper;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.jei.AlchemistCauldronJeiRecipe;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;

public final class AlchemistCauldronRecipeMaker {
    private AlchemistCauldronRecipeMaker() {
    }

    public static List<AlchemistCauldronJeiRecipe> getRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Stream.of(AlchemistCauldronRecipeMaker.getScrollRecipes(vanillaRecipeFactory, ingredientManager), AlchemistCauldronRecipeMaker.getCustomRecipes(vanillaRecipeFactory, ingredientManager), AlchemistCauldronRecipeMaker.getPotionRecipes(vanillaRecipeFactory, ingredientManager)).flatMap(x -> x).toList();
    }

    private static Stream<AlchemistCauldronJeiRecipe> getScrollRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Arrays.stream(SpellRarity.values()).map(AlchemistCauldronRecipeMaker::enumerateSpellsForRarity);
    }

    private static Stream<AlchemistCauldronJeiRecipe> getCustomRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        List<ItemStack> reagents = ingredientManager.getAllItemStacks().stream().filter(AlchemistCauldronRecipeRegistry::isValidIngredient).toList();
        return reagents.stream().flatMap(reagentStack -> AlchemistCauldronRecipeRegistry.getRecipes().stream().filter(recipe -> CauldronPlatformHelper.itemMatches(reagentStack, recipe.getIngredient())).map(recipe -> {
            ItemStack result = recipe.getResult();
            if (result.getCount() == 4) {
                result.setCount(1);
            }
            return new AlchemistCauldronJeiRecipe(List.of(reagentStack), List.of(result), List.of(recipe.getInput()));
        }));
    }

    private static Stream<AlchemistCauldronJeiRecipe> getPotionRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        if (!((Boolean)ServerConfigs.ALLOW_CAULDRON_BREWING.get()).booleanValue()) {
            return Stream.of(new AlchemistCauldronJeiRecipe[0]);
        }
        List<ItemStack> potionReagents = ingredientManager.getAllItemStacks().stream().filter(AlchemistCauldronRecipeMaker::isIngredient).toList();
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return Stream.of(new AlchemistCauldronJeiRecipe[0]);
        }
        return potionReagents.stream().flatMap(reagentStack -> ingredientManager.getAllItemStacks().stream().filter(itemStack -> itemStack.getItem() instanceof PotionItem && level.potionBrewing().hasMix(itemStack, reagentStack)).map(baseItem -> new AlchemistCauldronJeiRecipe(List.of(reagentStack), List.of(level.potionBrewing().mix(reagentStack, baseItem)), List.of(baseItem))));
    }

    private static AlchemistCauldronJeiRecipe enumerateSpellsForRarity(SpellRarity spellRarity) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> catalysts = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ItemStack scrollStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
        SpellRegistry.getEnabledSpells().forEach(spell -> IntStream.rangeClosed(spell.getMinLevel(), spell.getMaxLevel()).filter(spellLevel -> spell.getRarity(spellLevel) == spellRarity).forEach(filteredLevel -> inputs.add(AlchemistCauldronRecipeMaker.getScrollStack(scrollStack, spell, filteredLevel))));
        ItemStack ink = new ItemStack((ItemLike)InkItem.getInkForRarity(spellRarity));
        ItemStack waterBottle = new ItemStack((ItemLike)Items.POTION);
        waterBottle.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
        inputs.forEach(itemStack -> {
            catalysts.add(waterBottle);
            outputs.add(ink);
        });
        return new AlchemistCauldronJeiRecipe(inputs, outputs, catalysts);
    }

    private static ItemStack getScrollStack(ItemStack stack, AbstractSpell spell, int spellLevel) {
        ItemStack scrollStack = stack.copy();
        ISpellContainer.createScrollContainer(spell, spellLevel, scrollStack);
        return scrollStack;
    }

    private static boolean isIngredient(ItemStack itemStack) {
        try {
            return Minecraft.getInstance().level.potionBrewing().isIngredient(itemStack);
        }
        catch (LinkageError | RuntimeException e) {
            IronsSpellbooks.LOGGER.error("Failed to check if item is a potion reagent {}.", (Object)itemStack.toString(), (Object)e);
            return false;
        }
    }
}

