/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.item.curios;

import io.redspace.ironsspellbooks.api.item.curios.AffinityData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.item.curios.SimpleDescriptiveCurio;
import io.redspace.ironsspellbooks.render.AffinityRingRenderer;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class AffinityRing
extends SimpleDescriptiveCurio {
    public AffinityRing(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        AffinityData affinity = AffinityData.getAffinityData(pStack);
        AbstractSpell spell = affinity.getSpell();
        if (!spell.equals(SpellRegistry.none())) {
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"curios.modifiers.ring").withStyle(ChatFormatting.GOLD));
            MutableComponent name = spell.getDisplayName(MinecraftInstanceHelper.instance.player()).withStyle(spell.getSchoolType().getDisplayName().getStyle());
            tooltip.add((Component)Component.literal((String)" ").append((Component)(affinity.bonus() == 1 ? Component.translatable((String)"tooltip.irons_spellbooks.enhance_spell_level", (Object[])new Object[]{name}) : Component.translatable((String)"tooltip.irons_spellbooks.enhance_spell_level_plural", (Object[])new Object[]{affinity.bonus(), name})).withStyle(ChatFormatting.YELLOW)));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.irons_spellbooks.empty_affinity_ring").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    public Component getName(ItemStack pStack) {
        return Component.translatable((String)this.getDescriptionId(pStack), (Object[])new Object[]{AffinityData.getAffinityData(pStack).getNameForItem()});
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new AffinityRingRenderer(Minecraft.getInstance().getItemRenderer(), Minecraft.getInstance().getEntityModels());
            }
        });
    }
}

