/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.item;

import io.redspace.ironsspellbooks.item.armor.UpgradeType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class UpgradeOrbItem
extends Item {
    private final UpgradeType upgrade;
    private static final Component TOOLTIP_HEADER = Component.translatable((String)"tooltip.irons_spellbooks.upgrade_tooltip").withStyle(ChatFormatting.GRAY);
    private final Component TOOLTIP_TEXT;

    public UpgradeOrbItem(UpgradeType upgrade, Item.Properties pProperties) {
        super(pProperties);
        this.upgrade = upgrade;
        this.TOOLTIP_TEXT = Component.literal((String)" ").append((Component)Component.translatable((String)("attribute.modifier.plus." + upgrade.getOperation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(upgrade.getAmountPerUpgrade() * (float)(upgrade.getOperation() == AttributeModifier.Operation.ADD_VALUE ? 1 : 100)), Component.translatable((String)((Attribute)upgrade.getAttribute().value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
    }

    public UpgradeType getUpgradeType() {
        return this.upgrade;
    }

    public Component getName(ItemStack pStack) {
        return super.getName(pStack);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext context, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, context, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.empty());
        pTooltipComponents.add(TOOLTIP_HEADER);
        pTooltipComponents.add(this.TOOLTIP_TEXT);
    }
}

