/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.magic_missile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.spells.fireball.FireballRenderer;
import io.redspace.ironsspellbooks.entity.spells.magic_missile.MagicMissileProjectile;
import io.redspace.ironsspellbooks.render.RenderHelper;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;

public class MagicMissileRenderer
extends EntityRenderer<MagicMissileProjectile> {
    private static final ResourceLocation TEXTURE = IronsSpellbooks.id("textures/entity/magic_missile/magic_missile.png");
    private static final ResourceLocation[] FIRE_TEXTURES = new ResourceLocation[]{IronsSpellbooks.id("textures/entity/magic_missile/fire_1.png"), IronsSpellbooks.id("textures/entity/magic_missile/fire_2.png"), IronsSpellbooks.id("textures/entity/magic_missile/fire_3.png"), IronsSpellbooks.id("textures/entity/magic_missile/fire_4.png")};
    private final ModelPart body;
    protected final ModelPart outline;

    public MagicMissileRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.bakeLayer(FireballRenderer.MODEL_LAYER_LOCATION);
        this.body = modelpart.getChild("body");
        this.outline = modelpart.getChild("outline");
    }

    public void render(MagicMissileProjectile entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.pushPose();
        Vec3 motion = entity.getDeltaMovement();
        float xRot = -((float)(Mth.atan2((double)motion.horizontalDistance(), (double)motion.y) * 57.2957763671875) - 90.0f);
        float yRot = -((float)(Mth.atan2((double)motion.z, (double)motion.x) * 57.2957763671875) + 90.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(yRot));
        poseStack.mulPose(Axis.XP.rotationDegrees(xRot));
        poseStack.scale(0.35f, 0.35f, 0.45f);
        VertexConsumer consumer = bufferSource.getBuffer(this.renderType(this.getTextureLocation(entity)));
        this.body.render(poseStack, consumer, 0xF000F0, OverlayTexture.NO_OVERLAY, RenderHelper.colorf(0.8f, 0.8f, 0.8f));
        poseStack.scale(0.8f, 0.8f, 0.8f);
        poseStack.translate(0.0f, 0.0f, 0.4f);
        consumer = bufferSource.getBuffer(this.renderType(this.getFireTextureLocation(entity)));
        this.outline.render(poseStack, consumer, 0xF000F0, OverlayTexture.NO_OVERLAY, RenderHelper.colorf(0.8f, 0.8f, 0.8f));
        poseStack.popPose();
        super.render((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public RenderType renderType(ResourceLocation TEXTURE) {
        return RenderType.energySwirl((ResourceLocation)TEXTURE, (float)0.0f, (float)0.0f);
    }

    public ResourceLocation getTextureLocation(MagicMissileProjectile entity) {
        return TEXTURE;
    }

    public ResourceLocation getFireTextureLocation(Projectile entity) {
        int frame = entity.tickCount % FIRE_TEXTURES.length;
        return FIRE_TEXTURES[frame];
    }
}

