/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.fireball;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

public class SmallMagicFireball
extends AbstractMagicProjectile
implements IEntityWithComplexSpawn {
    @Nullable
    Entity cachedHomingTarget;
    @Nullable
    UUID homingTargetUUID;

    public SmallMagicFireball(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setNoGravity(true);
    }

    public SmallMagicFireball(Level pLevel, LivingEntity pShooter) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.SMALL_FIREBALL_PROJECTILE.get()), pLevel);
        this.setOwner((Entity)pShooter);
    }

    public void shoot(Vec3 rotation, float inaccuracy) {
        double speed = rotation.length();
        Vec3 offset = Utils.getRandomVec3(1.0).normalize().scale((double)inaccuracy);
        Vec3 motion = rotation.normalize().add(offset).normalize().scale(speed);
        super.shoot(motion);
    }

    @Nullable
    public Entity getHomingTarget() {
        if (this.cachedHomingTarget != null && !this.cachedHomingTarget.isRemoved()) {
            return this.cachedHomingTarget;
        }
        if (this.homingTargetUUID != null && this.level instanceof ServerLevel) {
            this.cachedHomingTarget = ((ServerLevel)this.level).getEntity(this.homingTargetUUID);
            return this.cachedHomingTarget;
        }
        return null;
    }

    public void setHomingTarget(LivingEntity entity) {
        this.homingTargetUUID = entity.getUUID();
        this.cachedHomingTarget = entity;
    }

    @Override
    public void tick() {
        super.tick();
        Entity homingTarget = this.getHomingTarget();
        if (homingTarget != null && !this.doHomingTowards(homingTarget)) {
            this.homingTargetUUID = null;
            this.cachedHomingTarget = null;
        }
    }

    private boolean doHomingTowards(Entity entity) {
        if (entity.isRemoved()) {
            return false;
        }
        Vec3 motion = this.getDeltaMovement();
        double speed = this.getDeltaMovement().length();
        Vec3 delta = entity.getBoundingBox().getCenter().subtract(this.position()).add(entity.getDeltaMovement());
        float f = 0.08f;
        Vec3 newMotion = new Vec3(Mth.lerp((double)f, (double)motion.x, (double)delta.x), Mth.lerp((double)f, (double)motion.y, (double)delta.y), Mth.lerp((double)f, (double)motion.z, (double)delta.z)).normalize().scale(speed);
        this.setDeltaMovement(newMotion);
        return this.tickCount <= 10 || !(newMotion.dot(delta) < 0.0);
    }

    @Override
    public void trailParticles() {
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() - vec3.x;
        double d1 = this.getY() - vec3.y;
        double d2 = this.getZ() - vec3.z;
        int count = Mth.clamp((int)((int)(vec3.lengthSqr() * 4.0)), (int)1, (int)5);
        for (int i = 0; i < count; ++i) {
            Vec3 random = Utils.getRandomVec3(0.1);
            float f = (float)i / (float)count;
            double x = Mth.lerp((double)f, (double)d0, (double)this.getX());
            double y = Mth.lerp((double)f, (double)d1, (double)this.getY());
            double z = Mth.lerp((double)f, (double)d2, (double)this.getZ());
            this.level.addParticle(ParticleHelper.EMBERS, x - random.x, y + 0.5 - random.y, z - random.z, random.x * 0.5, random.y * 0.5, random.z * 0.5);
        }
    }

    @Override
    public void impactParticles(double x, double y, double z) {
    }

    @Override
    public float getSpeed() {
        return 1.85f;
    }

    @Override
    public Optional<Holder<SoundEvent>> getImpactSound() {
        return Optional.empty();
    }

    @Override
    protected void onHitEntity(EntityHitResult pResult) {
        if (!this.level.isClientSide) {
            Entity target = pResult.getEntity();
            Entity owner = this.getOwner();
            DamageSources.applyDamage(target, this.damage, SpellRegistry.BLAZE_STORM_SPELL.get().getDamageSource((Entity)this, owner));
            if (target.getUUID().equals(this.homingTargetUUID)) {
                target.invulnerableTime = 0;
            }
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        BlockPos blockpos;
        super.onHitBlock(pResult);
        if (!this.level.isClientSide && ((Boolean)ServerConfigs.SPELL_GREIFING.get()).booleanValue() && this.level.isEmptyBlock(blockpos = pResult.getBlockPos().relative(pResult.getDirection()))) {
            this.level.setBlockAndUpdate(blockpos, BaseFireBlock.getState((BlockGetter)this.level, (BlockPos)blockpos));
        }
    }

    @Override
    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
        if (!this.level.isClientSide) {
            this.discard();
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.homingTargetUUID != null) {
            tag.putUUID("homingTarget", this.homingTargetUUID);
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("homingTarget", 11)) {
            this.homingTargetUUID = tag.getUUID("homingTarget");
        }
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        IronsSpellbooks.LOGGER.debug("Smallmagicfireball.writespawndata: {}", (Object)this.homingTargetUUID);
        Entity owner = this.getOwner();
        buffer.writeInt(owner == null ? 0 : owner.getId());
        Entity homingTarget = this.getHomingTarget();
        buffer.writeInt(homingTarget == null ? 0 : homingTarget.getId());
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        Entity homingTarget;
        Entity owner = this.level.getEntity(additionalData.readInt());
        if (owner != null) {
            this.setOwner(owner);
        }
        if ((homingTarget = this.level.getEntity(additionalData.readInt())) != null) {
            this.cachedHomingTarget = homingTarget;
            this.homingTargetUUID = homingTarget.getUUID();
        }
        IronsSpellbooks.LOGGER.debug("Smallmagicfireball.readSpawnData: {}", (Object)this.homingTargetUUID);
    }
}

