/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.black_hole;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;

public class BlackHole
extends Projectile
implements AntiMagicSusceptible {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.defineId(BlackHole.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    List<Entity> trackingEntities = new ArrayList<Entity>();
    private int soundTick;
    private float damage;
    private static final int loopSoundDurationInTicks = 320;

    public BlackHole(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BlackHole(Level pLevel, LivingEntity owner) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.BLACK_HOLE.get()), pLevel);
        this.setOwner((Entity)owner);
    }

    @Override
    public void onAntiMagic(MagicData playerMagicData) {
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public EntityDimensions getDimensions(Pose pPose) {
        return EntityDimensions.scalable((float)(this.getRadius() * 2.0f), (float)(this.getRadius() * 2.0f));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(DATA_RADIUS, (Object)Float.valueOf(5.0f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (DATA_RADIUS.equals(pKey)) {
            this.refreshDimensions();
            if (this.getRadius() < 0.1f) {
                this.discard();
            }
        }
        super.onSyncedDataUpdated(pKey);
    }

    public void setRadius(float pRadius) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, (Object)Float.valueOf(Math.min(pRadius, 48.0f)));
        }
    }

    public float getRadius() {
        return ((Float)this.getEntityData().get(DATA_RADIUS)).floatValue();
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putFloat("Radius", this.getRadius());
        pCompound.putInt("Age", this.tickCount);
        pCompound.putFloat("Damage", this.getDamage());
        super.addAdditionalSaveData(pCompound);
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        this.tickCount = pCompound.getInt("Age");
        this.damage = pCompound.getFloat("Damage");
        if (this.damage == 0.0f) {
            this.damage = 1.0f;
        }
        if (pCompound.getInt("Radius") > 0) {
            this.setRadius(pCompound.getFloat("Radius"));
        }
        super.readAdditionalSaveData(pCompound);
    }

    public void tick() {
        super.tick();
        int update = Math.max((int)(this.getRadius() / 2.0f), 2);
        if (this.tickCount % update == 0) {
            this.updateTrackingEntities();
        }
        AABB bb = this.getBoundingBox();
        float radius = (float)bb.getXsize();
        boolean hitTick = this.tickCount % 10 == 0;
        for (Entity entity : this.trackingEntities) {
            float f;
            Vec3 center;
            float distance;
            if (entity == this.getOwner() || DamageSources.isFriendlyFireBetween(this.getOwner(), entity) || entity.isSpectator() || (distance = (float)(center = bb.getCenter()).distanceTo(entity.position())) > radius) continue;
            float f2 = 1.0f - distance / radius;
            float scale = f2 * f2 * f2 * f2 * 0.25f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = Mth.clamp((float)(1.0f - (float)livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)), (float)0.3f, (float)1.0f);
            } else {
                f = 1.0f;
            }
            float resistance = f;
            float bossResistance = entity.getType().is(Tags.EntityTypes.BOSSES) ? 0.5f : 1.0f;
            Vec3 diff = center.subtract(entity.position()).scale((double)(scale * resistance * bossResistance));
            entity.push(diff.x, diff.y, diff.z);
            if (hitTick && distance < 9.0f && this.canHitEntity(entity)) {
                DamageSources.applyDamage(entity, this.damage, SpellRegistry.BLACK_HOLE_SPELL.get().getDamageSource((Entity)this, this.getOwner()));
            }
            entity.fallDistance = 0.0f;
        }
        if (!this.level().isClientSide) {
            if (this.tickCount > 640) {
                this.discard();
                this.playSound((SoundEvent)SoundRegistry.BLACK_HOLE_CAST.get(), this.getRadius() / 2.0f, 1.0f);
                MagicManager.spawnParticles(this.level(), ParticleHelper.UNSTABLE_ENDER, this.getX(), this.getY() + (double)this.getRadius(), this.getZ(), 200, 1.0, 1.0, 1.0, 1.0, true);
            } else if ((this.tickCount - 1) % 320 == 0) {
                this.playSound((SoundEvent)SoundRegistry.BLACK_HOLE_LOOP.get(), this.getRadius() / 3.0f, 1.0f);
            }
        }
    }

    private void updateTrackingEntities() {
        this.trackingEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0));
    }

    public boolean displayFireAnimation() {
        return false;
    }
}

