/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.spells.AbstractShieldEntity;
import io.redspace.ironsspellbooks.entity.spells.ShieldPart;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

public abstract class AbstractMagicProjectile
extends Projectile
implements AntiMagicSusceptible {
    protected static final int EXPIRE_TIME = 300;
    protected float damage;
    protected float explosionRadius;

    public abstract void trailParticles();

    public abstract void impactParticles(double var1, double var3, double var5);

    public abstract float getSpeed();

    public abstract Optional<Holder<SoundEvent>> getImpactSound();

    public AbstractMagicProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void shoot(Vec3 rotation) {
        this.setDeltaMovement(rotation.scale((double)this.getSpeed()));
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getExplosionRadius() {
        return this.explosionRadius;
    }

    public void setExplosionRadius(float explosionRadius) {
        this.explosionRadius = explosionRadius;
    }

    protected boolean canHitEntity(Entity pTarget) {
        return super.canHitEntity(pTarget) && pTarget != this.getOwner();
    }

    public void checkDespawn() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!serverLevel.getChunkSource().chunkMap.getDistanceManager().inEntityTickingRange(this.chunkPosition().toLong())) {
                this.discard();
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 300) {
            this.discard();
            return;
        }
        if (this.level.isClientSide) {
            this.trailParticles();
        }
        this.handleHitDetection();
        this.travel();
    }

    public void handleHitDetection() {
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (hitresult.getType() != HitResult.Type.MISS && !((ProjectileImpactEvent)NeoForge.EVENT_BUS.post((Event)new ProjectileImpactEvent((Projectile)this, hitresult))).isCanceled()) {
            this.onHit(hitresult);
        }
    }

    public void travel() {
        this.xOld = this.getX();
        this.yOld = this.getY();
        this.zOld = this.getZ();
        this.setPos(this.position().add(this.getDeltaMovement()));
        ProjectileUtil.rotateTowardsMovement((Entity)this, (float)1.0f);
        if (!this.isNoGravity()) {
            Vec3 vec34 = this.getDeltaMovement();
            this.setDeltaMovement(vec34.x, vec34.y - (double)0.05f, vec34.z);
        }
    }

    protected void onHit(HitResult hitresult) {
        super.onHit(hitresult);
        if (!this.level.isClientSide) {
            this.impactParticles(this.getX(), this.getY(), this.getZ());
            this.getImpactSound().ifPresent(this::doImpactSound);
        }
    }

    public boolean shouldBeSaved() {
        return super.shouldBeSaved() && !Objects.equals(this.getRemovalReason(), Entity.RemovalReason.UNLOADED_TO_CHUNK);
    }

    protected void doImpactSound(Holder<SoundEvent> sound) {
        this.level.playSound(null, this.getX(), this.getY(), this.getZ(), sound, SoundSource.NEUTRAL, 2.0f, 0.9f + Utils.random.nextFloat() * 0.2f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    @Override
    public void onAntiMagic(MagicData playerMagicData) {
        this.impactParticles(this.getX(), this.getY(), this.getZ());
        this.discard();
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("Damage", this.getDamage());
        if (this.explosionRadius != 0.0f) {
            tag.putFloat("ExplosionRadius", this.explosionRadius);
        }
        tag.putInt("Age", this.tickCount);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.damage = tag.getFloat("Damage");
        if (tag.contains("ExplosionRadius")) {
            this.explosionRadius = tag.getFloat("ExplosionRadius");
        }
        this.tickCount = tag.getInt("Age");
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
        if (!this.shouldPierceShields() && (pResult.getEntity() instanceof ShieldPart || pResult.getEntity() instanceof AbstractShieldEntity)) {
            this.onHitBlock(new BlockHitResult(pResult.getEntity().position(), Direction.fromYRot((double)this.getYRot()), pResult.getEntity().blockPosition(), false));
        }
    }

    public boolean isOnFire() {
        return false;
    }

    protected boolean shouldPierceShields() {
        return false;
    }
}

