/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.wizards;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.entity.mobs.goals.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.goals.WarlockAttackGoal;
import io.redspace.ironsspellbooks.network.SyncAnimationPacket;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class GenericAnimatedWarlockAttackGoal<T extends PathfinderMob & IMagicEntity>
extends WarlockAttackGoal {
    List<AttackAnimationData> moveList = new ArrayList<AttackAnimationData>();
    final T mob;
    int meleeAnimTimer = -1;
    @Nullable
    public AttackAnimationData currentAttack;
    @Nullable
    public AttackAnimationData nextAttack = this.randomizeNextAttack(0.0f);
    @Nullable
    public AttackAnimationData queueCombo;
    float comboChance = 0.3f;

    public GenericAnimatedWarlockAttackGoal(T abstractSpellCastingMob, double pSpeedModifier, int minAttackInterval, int maxAttackInterval, float meleeRange) {
        super((IMagicEntity)abstractSpellCastingMob, pSpeedModifier, minAttackInterval, maxAttackInterval, meleeRange);
        this.wantsToMelee = true;
        this.mob = abstractSpellCastingMob;
    }

    @Override
    protected void handleAttackLogic(double distanceSquared) {
        if (this.meleeAnimTimer < 0 && (!this.wantsToMelee || distanceSquared > (double)(this.meleeRange * this.meleeRange) || ((IMagicEntity)this.mob).isCasting())) {
            super.handleAttackLogic(distanceSquared);
            return;
        }
        this.mob.getLookControl().setLookAt((Entity)this.target);
        if (this.meleeAnimTimer > 0) {
            this.forceFaceTarget();
            --this.meleeAnimTimer;
            if (this.currentAttack.isHitFrame(this.meleeAnimTimer)) {
                this.playSwingSound();
                Vec3 lunge = this.target.position().subtract(this.mob.position()).normalize().scale((double)0.45f);
                this.mob.push(lunge.x, lunge.y, lunge.z);
                if (distanceSquared <= (double)(this.meleeRange * this.meleeRange)) {
                    boolean flag = this.mob.doHurtTarget((Entity)this.target);
                    this.target.invulnerableTime = 0;
                    if (flag && this.currentAttack.isSingleHit()) {
                        float f = this.mob.getRandom().nextFloat();
                        int n = this.target.isBlocking() ? 2 : 1;
                        if (f < this.comboChance * (float)n) {
                            this.queueCombo = this.randomizeNextAttack(0.0f);
                        }
                    }
                }
            }
        } else if (this.queueCombo != null && this.target != null && !this.target.isDeadOrDying()) {
            this.nextAttack = this.queueCombo;
            this.queueCombo = null;
            this.doMeleeAction();
        } else if (this.meleeAnimTimer == 0) {
            this.nextAttack = this.randomizeNextAttack((float)distanceSquared);
            this.resetAttackTimer(distanceSquared);
            this.meleeAnimTimer = -1;
        } else if (distanceSquared < (double)(this.meleeRange * this.meleeRange) * 1.2 * 1.2) {
            if (--this.attackTime == 0) {
                this.doMeleeAction();
            } else if (this.attackTime < 0) {
                this.resetAttackTimer(distanceSquared);
            }
        }
    }

    private AttackAnimationData randomizeNextAttack(float distanceSquared) {
        if (this.moveList.isEmpty()) {
            return null;
        }
        return this.moveList.get(this.mob.getRandom().nextInt(this.moveList.size()));
    }

    private void forceFaceTarget() {
        double d0 = this.target.getX() - this.mob.getX();
        double d1 = this.target.getZ() - this.mob.getZ();
        float yRot = (float)(Mth.atan2((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
        this.mob.setYBodyRot(yRot);
        this.mob.setYHeadRot(yRot);
        this.mob.setYRot(yRot);
    }

    @Override
    protected void doMeleeAction() {
        this.currentAttack = this.nextAttack;
        if (this.currentAttack != null) {
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.meleeAnimTimer = this.currentAttack.lengthInTicks;
            PacketDistributor.sendToPlayersTrackingEntity(this.mob, new SyncAnimationPacket<T>(this.currentAttack.animationId, this.mob), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public boolean canContinueToUse() {
        return super.canContinueToUse() || this.meleeAnimTimer > 0;
    }

    @Override
    public void stop() {
        super.stop();
        this.meleeAnimTimer = -1;
        this.queueCombo = null;
    }

    public void playSwingSound() {
        this.mob.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, (float)Mth.randomBetweenInclusive((RandomSource)this.mob.getRandom(), (int)12, (int)18) * 0.1f);
    }

    public GenericAnimatedWarlockAttackGoal<T> setMoveset(List<AttackAnimationData> moveset) {
        this.moveList = moveset;
        this.nextAttack = this.randomizeNextAttack(0.0f);
        return this;
    }

    public GenericAnimatedWarlockAttackGoal<T> setComboChance(float comboChance) {
        this.comboChance = comboChance;
        return this;
    }
}

