/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.keeper;

import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMobModel;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.WalkAnimationState;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;

public class KeeperModel
extends AbstractSpellCastingMobModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/entity/keeper/keeper.png");
    public static final ResourceLocation modelResource = new ResourceLocation("irons_spellbooks", "geo/citadel_keeper.geo.json");
    private int lastTick;
    private float legTween = 1.0f;

    @Override
    public ResourceLocation getTextureResource(AbstractSpellCastingMob object) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation getModelResource(AbstractSpellCastingMob object) {
        return modelResource;
    }

    @Override
    public void setCustomAnimations(AbstractSpellCastingMob entity, long instanceId, AnimationState<AbstractSpellCastingMob> animationState) {
        super.setCustomAnimations(entity, instanceId, animationState);
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        float partialTick = animationState.getPartialTick();
        GeoBone rightLeg = this.getAnimationProcessor().getBone("right_leg");
        GeoBone leftLeg = this.getAnimationProcessor().getBone("left_leg");
        GeoBone rightArm = this.getAnimationProcessor().getBone("right_arm");
        GeoBone leftArm = this.getAnimationProcessor().getBone("left_arm");
        GeoBone body = this.getAnimationProcessor().getBone("body");
        boolean tick = this.lastTick != entity.tickCount;
        this.lastTick = entity.tickCount;
        WalkAnimationState walkAnimationState = entity.walkAnimation;
        float pLimbSwingAmount = 0.0f;
        float pLimbSwing = 0.0f;
        if (entity.isAlive()) {
            pLimbSwingAmount = walkAnimationState.speed(partialTick);
            pLimbSwing = walkAnimationState.position(partialTick);
            if (pLimbSwingAmount > 1.0f) {
                pLimbSwingAmount = 1.0f;
            }
            if (entity.hurtTime > 0) {
                pLimbSwingAmount *= 0.25f;
            }
        }
        if (!entity.isPassenger() || !entity.getVehicle().shouldRiderSit()) {
            float strength = 0.75f;
            rightLeg.updatePosition(0.0f, Mth.cos((float)(pLimbSwing * 0.6662f)) * 4.0f * strength * pLimbSwingAmount, -Mth.sin((float)(pLimbSwing * 0.6662f)) * 4.0f * pLimbSwingAmount);
            leftLeg.updatePosition(0.0f, Mth.cos((float)(pLimbSwing * 0.6662f - (float)Math.PI)) * 4.0f * strength * pLimbSwingAmount, -Mth.sin((float)(pLimbSwing * 0.6662f - (float)Math.PI)) * 4.0f * pLimbSwingAmount);
            body.updatePosition(0.0f, Mth.abs((float)Mth.cos((float)((pLimbSwing * 1.2662f - 1.5707964f) * 0.5f))) * 2.0f * strength * pLimbSwingAmount, 0.0f);
            if (tick) {
                this.legTween = !entity.isAnimating() || entity.shouldAlwaysAnimateLegs() ? Mth.lerp((float)0.9f, (float)0.0f, (float)1.0f) : Mth.lerp((float)0.9f, (float)1.0f, (float)0.0f);
            }
            rightLeg.setRotX(Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount * this.legTween * strength);
            leftLeg.setRotX(Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount * this.legTween * strength);
        }
    }

    protected static void updatePosition(GeoBone bone, float x, float y, float z) {
        bone.setPosX(x);
        bone.setPosY(y);
        bone.setPosZ(z);
    }

    protected static void updateRotation(GeoBone bone, float x, float y, float z) {
        bone.setRotX(x);
        bone.setRotY(y);
        bone.setRotZ(z);
    }
}

