/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.frozen_humanoid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.redspace.ironsspellbooks.entity.mobs.frozen_humanoid.FrozenHumanoid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class FrozenHumanoidRenderer
extends LivingEntityRenderer<FrozenHumanoid, HumanoidModel<FrozenHumanoid>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/entity/frozen_humanoid.png");

    public FrozenHumanoidRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER)), 0.36f);
    }

    public ResourceLocation getTextureLocation(FrozenHumanoid pEntity) {
        return TEXTURE;
    }

    protected float getBob(FrozenHumanoid pLivingBase, float pPartialTick) {
        return 0.0f;
    }

    public void render(FrozenHumanoid iceMan, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        Direction direction;
        boolean shouldSit;
        pMatrixStack.pushPose();
        ((HumanoidModel)this.model).attackTime = this.getAttackAnim(iceMan, pPartialTicks);
        ((HumanoidModel)this.model).riding = shouldSit = iceMan.isSitting();
        ((HumanoidModel)this.model).young = iceMan.isBaby();
        float bodyYRot = iceMan.yBodyRot;
        float yHeadRot = iceMan.yHeadRot;
        float f2 = yHeadRot - bodyYRot;
        if (shouldSit) {
            f2 = yHeadRot - bodyYRot;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            bodyYRot = yHeadRot - f3;
            if (f3 * f3 > 2500.0f) {
                bodyYRot += f3 * 0.2f;
            }
            f2 = yHeadRot - bodyYRot;
        }
        float f6 = Mth.lerp((float)pPartialTicks, (float)iceMan.xRotO, (float)iceMan.getXRot());
        if (FrozenHumanoidRenderer.isEntityUpsideDown((LivingEntity)iceMan)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        if (iceMan.hasPose(Pose.SLEEPING) && (direction = iceMan.getBedOrientation()) != null) {
            float f4 = iceMan.getEyeHeight(Pose.STANDING) - 0.1f;
            pMatrixStack.translate((double)((float)(-direction.getStepX()) * f4), 0.0, (double)((float)(-direction.getStepZ()) * f4));
        }
        float bob = 0.0f;
        pMatrixStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale(iceMan, pMatrixStack, pPartialTicks);
        pMatrixStack.translate(0.0, (double)-1.501f, 0.0);
        float limbSwingAmount = iceMan.getLimbSwingAmount();
        float limbSwing = iceMan.getLimbSwing();
        ((HumanoidModel)this.model).prepareMobModel((LivingEntity)iceMan, limbSwing, limbSwingAmount, pPartialTicks);
        ((HumanoidModel)this.model).setupAnim((LivingEntity)iceMan, limbSwing, limbSwingAmount, bob, f2, f6);
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = this.isBodyVisible(iceMan);
        boolean flag1 = !flag && !iceMan.isInvisibleTo((Player)minecraft.player);
        boolean flag2 = minecraft.shouldEntityAppearGlowing((Entity)iceMan);
        RenderType rendertype = this.getRenderType(iceMan, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = pBuffer.getBuffer(rendertype);
            int n = FrozenHumanoidRenderer.getOverlayCoords((LivingEntity)iceMan, (float)this.getWhiteOverlayProgress(iceMan, pPartialTicks));
        }
        pMatrixStack.popPose();
    }

    protected float getAttackAnim(FrozenHumanoid pLivingBase, float pPartialTickTime) {
        return pLivingBase.getAttacktime();
    }
}

