/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.dead_king_boss;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class FadeableSoundInstance
extends AbstractTickableSoundInstance {
    boolean starting = false;
    private int transitionTicks;
    private boolean triggerEnd = false;
    private static final int START_TRANSITION_TIME = 40;
    private static final int END_TRANSITION_TIME = 40;

    protected FadeableSoundInstance(SoundEvent soundEvent, SoundSource source, boolean loop) {
        super(soundEvent, source, SoundInstance.createUnseededRandom());
        this.attenuation = SoundInstance.Attenuation.NONE;
        this.looping = loop;
        this.delay = 0;
        this.volume = 1.0f;
        this.starting = false;
    }

    public void tick() {
        if (this.transitionTicks > 0) {
            --this.transitionTicks;
        }
        if (this.starting) {
            this.volume = 1.0f - (float)this.transitionTicks / 40.0f;
            if (this.transitionTicks == 0) {
                this.starting = false;
            }
        }
        if (this.triggerEnd) {
            this.volume = (float)this.transitionTicks / 40.0f;
            if (this.transitionTicks == 0) {
                this.stop();
            }
        }
    }

    public boolean canStartSilent() {
        return true;
    }

    public void triggerStop() {
        this.triggerEnd = true;
        this.transitionTicks = this.volume < 1.0f ? (int)(40.0f * this.volume) : 40;
    }

    public void triggerStart() {
        this.triggerEnd = false;
        this.transitionTicks = this.volume < 1.0f ? (int)(40.0f * this.volume) : 40;
        this.starting = true;
    }
}

