/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.dead_king_boss;

import io.redspace.ironsspellbooks.config.ClientConfigs;
import io.redspace.ironsspellbooks.entity.mobs.dead_king_boss.DeadKingBoss;
import io.redspace.ironsspellbooks.entity.mobs.dead_king_boss.FadeableSoundInstance;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(value={Dist.CLIENT})
public class DeadKingMusicManager {
    @Nullable
    private static DeadKingMusicManager INSTANCE;
    static final SoundSource SOUND_SOURCE;
    static final int FIRST_PHASE_MELODY_LENGTH_MILIS = 28790;
    static final int INTRO_LENGTH_MILIS = 17600;
    DeadKingBoss boss;
    final SoundManager soundManager;
    FadeableSoundInstance beginSound;
    FadeableSoundInstance firstPhaseMelody;
    FadeableSoundInstance firstPhaseAccent;
    FadeableSoundInstance secondPhaseMelody;
    FadeableSoundInstance transitionMusic;
    Set<FadeableSoundInstance> layers = new HashSet<FadeableSoundInstance>();
    private int accentStage = 0;
    private long lastMilisPlayed;
    private boolean hasPlayedIntro;
    DeadKingBoss.Phases stage;
    boolean finishing = false;

    private DeadKingMusicManager(DeadKingBoss boss) {
        this.boss = boss;
        this.soundManager = Minecraft.getInstance().getSoundManager();
        this.stage = DeadKingBoss.Phases.values()[boss.getPhase()];
        this.beginSound = new FadeableSoundInstance((SoundEvent)SoundRegistry.DEAD_KING_MUSIC_INTRO.get(), SOUND_SOURCE, false);
        this.firstPhaseMelody = new FadeableSoundInstance((SoundEvent)SoundRegistry.DEAD_KING_FIRST_PHASE_MELODY.get(), SOUND_SOURCE, true);
        this.firstPhaseAccent = new FadeableSoundInstance((SoundEvent)SoundRegistry.DEAD_KING_FIRST_PHASE_ACCENT_01.get(), SOUND_SOURCE, false);
        this.secondPhaseMelody = new FadeableSoundInstance((SoundEvent)SoundRegistry.DEAD_KING_SECOND_PHASE_MELODY_ALT.get(), SOUND_SOURCE, true);
        this.transitionMusic = new FadeableSoundInstance((SoundEvent)SoundRegistry.DEAD_KING_SUSPENSE.get(), SOUND_SOURCE, false);
        this.init();
    }

    private void init() {
        this.soundManager.stop(null, SoundSource.MUSIC);
        switch (this.stage) {
            case FirstPhase: {
                this.addLayer(this.beginSound);
                this.lastMilisPlayed = System.currentTimeMillis();
                break;
            }
            case FinalPhase: {
                this.initSecondPhase();
            }
        }
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Pre event) {
        if (INSTANCE != null && !Minecraft.getInstance().isPaused()) {
            INSTANCE.tick();
        }
    }

    public static void createOrResumeInstance(DeadKingBoss boss) {
        if (INSTANCE == null || INSTANCE.isDone()) {
            if (((Boolean)ClientConfigs.ENABLE_BOSS_MUSIC.get()).booleanValue()) {
                INSTANCE = new DeadKingMusicManager(boss);
            }
        } else {
            INSTANCE.triggerResume(boss);
        }
    }

    public static void stop(DeadKingBoss boss) {
        if (INSTANCE != null && DeadKingMusicManager.INSTANCE.boss.getUUID().equals(boss.getUUID())) {
            INSTANCE.stopLayers();
            DeadKingMusicManager.INSTANCE.finishing = true;
        }
    }

    private void tick() {
        if (this.isDone() || this.finishing) {
            return;
        }
        if (this.boss.isDeadOrDying() || this.boss.isRemoved()) {
            this.stopLayers();
            this.finishing = true;
            return;
        }
        DeadKingBoss.Phases bossPhase = DeadKingBoss.Phases.values()[this.boss.getPhase()];
        switch (bossPhase) {
            case FirstPhase: {
                if (!this.hasPlayedIntro) {
                    if (this.soundManager.isActive((SoundInstance)this.beginSound) && this.lastMilisPlayed + 17600L >= System.currentTimeMillis()) break;
                    this.hasPlayedIntro = true;
                    this.layers.remove((Object)this.beginSound);
                    this.initFirstPhase();
                    break;
                }
                if (this.lastMilisPlayed + 57580L >= System.currentTimeMillis()) break;
                this.playAccent(this.firstPhaseAccent);
                break;
            }
            case Transitioning: {
                if (this.stage == DeadKingBoss.Phases.Transitioning) break;
                this.stage = DeadKingBoss.Phases.Transitioning;
                this.stopLayers();
                this.addLayer(this.transitionMusic);
                break;
            }
            case FinalPhase: {
                if (this.stage == DeadKingBoss.Phases.FinalPhase) break;
                this.stage = DeadKingBoss.Phases.FinalPhase;
                this.initSecondPhase();
            }
        }
    }

    private boolean isDone() {
        for (FadeableSoundInstance soundInstance : this.layers) {
            if (soundInstance.isStopped() || !this.soundManager.isActive((SoundInstance)soundInstance)) continue;
            return false;
        }
        return true;
    }

    private void addLayer(FadeableSoundInstance soundInstance) {
        this.layers.stream().filter(sound -> sound.isStopped() || !this.soundManager.isActive((SoundInstance)sound)).toList().forEach(this.layers::remove);
        this.soundManager.play((SoundInstance)soundInstance);
        this.layers.add(soundInstance);
    }

    private void playAccent(FadeableSoundInstance soundInstance) {
        ++this.accentStage;
        this.lastMilisPlayed = System.currentTimeMillis();
        this.addLayer(soundInstance);
    }

    public void stopLayers() {
        this.layers.forEach(FadeableSoundInstance::triggerStop);
    }

    public static void hardStop() {
        if (INSTANCE != null) {
            DeadKingMusicManager.INSTANCE.layers.forEach(arg_0 -> ((SoundManager)DeadKingMusicManager.INSTANCE.soundManager).stop(arg_0));
            INSTANCE = null;
        }
    }

    public void triggerResume(DeadKingBoss boss) {
        if (boss.getUUID().equals(this.boss.getUUID())) {
            this.boss = boss;
        }
        if (!this.boss.isRemoved()) {
            this.layers.forEach(sound -> {
                sound.triggerStart();
                if (!this.soundManager.isActive((SoundInstance)sound)) {
                    this.soundManager.play((SoundInstance)sound);
                }
            });
            this.finishing = false;
        }
    }

    private void initFirstPhase() {
        this.accentStage = 0;
        this.addLayer(this.firstPhaseMelody);
        this.playAccent(this.firstPhaseAccent);
    }

    private void initSecondPhase() {
        this.accentStage = 0;
        this.addLayer(this.secondPhaseMelody);
    }

    static {
        SOUND_SOURCE = SoundSource.RECORDS;
    }
}

