/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.TransformStack;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public abstract class AbstractSpellCastingMobModel
extends DefaultedEntityGeoModel<AbstractSpellCastingMob> {
    protected TransformStack transformStack = new TransformStack();

    public AbstractSpellCastingMobModel() {
        super(IronsSpellbooks.id("spellcastingmob"));
    }

    public ResourceLocation getModelResource(AbstractSpellCastingMob object) {
        return AbstractSpellCastingMob.modelResource;
    }

    public abstract ResourceLocation getTextureResource(AbstractSpellCastingMob var1);

    public ResourceLocation getAnimationResource(AbstractSpellCastingMob animatable) {
        return AbstractSpellCastingMob.animationInstantCast;
    }

    public void setCustomAnimations(AbstractSpellCastingMob entity, long instanceId, AnimationState<AbstractSpellCastingMob> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        if (Minecraft.getInstance().isPaused() || !entity.shouldBeExtraAnimated()) {
            return;
        }
        float partialTick = animationState.getPartialTick();
        GeoBone head = this.getAnimationProcessor().getBone("head");
        GeoBone body = this.getAnimationProcessor().getBone("body");
        GeoBone torso = this.getAnimationProcessor().getBone("torso");
        GeoBone rightArm = this.getAnimationProcessor().getBone("right_arm");
        GeoBone leftArm = this.getAnimationProcessor().getBone("left_arm");
        GeoBone rightLeg = this.getAnimationProcessor().getBone("right_leg");
        GeoBone leftLeg = this.getAnimationProcessor().getBone("left_leg");
        if (!entity.isAnimating() || entity.shouldAlwaysAnimateHead()) {
            this.transformStack.pushRotation(head, Mth.lerp((float)partialTick, (float)(-entity.xRotO), (float)(-entity.getXRot())) * ((float)Math.PI / 180), Mth.lerp((float)partialTick, (float)(Mth.wrapDegrees((float)(-entity.yHeadRotO + entity.yBodyRotO)) * ((float)Math.PI / 180)), (float)(Mth.wrapDegrees((float)(-entity.yHeadRot + entity.yBodyRot)) * ((float)Math.PI / 180))), 0.0f);
        }
        WalkAnimationState walkAnimationState = entity.walkAnimation;
        float pLimbSwingAmount = 0.0f;
        float pLimbSwing = 0.0f;
        if (entity.isAlive()) {
            pLimbSwingAmount = walkAnimationState.speed(partialTick);
            pLimbSwing = walkAnimationState.position(partialTick);
            if (entity.isBaby()) {
                pLimbSwing *= 3.0f;
            }
            if (pLimbSwingAmount > 1.0f) {
                pLimbSwingAmount = 1.0f;
            }
        }
        float f = 1.0f;
        if (entity.getFallFlyingTicks() > 4) {
            f = (float)entity.getDeltaMovement().lengthSqr();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        if (entity.isPassenger() && entity.getVehicle().shouldRiderSit()) {
            this.transformStack.pushRotation(rightLeg, 1.4137167f, -0.31415927f, -0.07853982f);
            this.transformStack.pushRotation(leftLeg, 1.4137167f, 0.31415927f, 0.07853982f);
        } else if (!entity.isAnimating() || entity.shouldAlwaysAnimateLegs()) {
            float strength = 0.75f;
            Vec3 facing = entity.getForward().multiply(1.0, 0.0, 1.0).normalize();
            Vec3 momentum = entity.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
            Vec3 facingOrth = new Vec3(-facing.z, 0.0, facing.x);
            float directionForward = (float)facing.dot(momentum);
            float directionSide = (float)facingOrth.dot(momentum) * 0.35f;
            float rightLateral = -Mth.sin((float)(pLimbSwing * 0.6662f)) * 4.0f * pLimbSwingAmount;
            float leftLateral = -Mth.sin((float)(pLimbSwing * 0.6662f - (float)Math.PI)) * 4.0f * pLimbSwingAmount;
            this.transformStack.pushPosition(rightLeg, rightLateral * directionSide, Mth.cos((float)(pLimbSwing * 0.6662f)) * 4.0f * strength * pLimbSwingAmount, rightLateral * directionForward);
            this.transformStack.pushRotation(rightLeg, Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount * strength, 0.0f, 0.0f);
            this.transformStack.pushPosition(leftLeg, leftLateral * directionSide, Mth.cos((float)(pLimbSwing * 0.6662f - (float)Math.PI)) * 4.0f * strength * pLimbSwingAmount, leftLateral * directionForward);
            this.transformStack.pushRotation(leftLeg, Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount * strength, 0.0f, 0.0f);
            if (entity.bobBodyWhileWalking()) {
                this.transformStack.pushPosition(body, 0.0f, Mth.abs((float)Mth.cos((float)((pLimbSwing * 1.2662f - 1.5707964f) * 0.5f))) * 2.0f * strength * pLimbSwingAmount, 0.0f);
            }
        }
        if (!entity.isAnimating()) {
            this.transformStack.pushRotationWithBase(rightArm, Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 2.0f * pLimbSwingAmount * 0.5f / f, 0.0f, 0.0f);
            this.transformStack.pushRotationWithBase(leftArm, Mth.cos((float)(pLimbSwing * 0.6662f)) * 2.0f * pLimbSwingAmount * 0.5f / f, 0.0f, 0.0f);
            this.bobBone(rightArm, entity.tickCount, 1.0f);
            this.bobBone(leftArm, entity.tickCount, -1.0f);
            if (entity.isDrinkingPotion()) {
                this.transformStack.pushRotation(entity.isLeftHanded() ? leftArm : rightArm, 0.61086524f, (float)(entity.isLeftHanded() ? -25 : 25) * ((float)Math.PI / 180), (float)(entity.isLeftHanded() ? 15 : -15) * ((float)Math.PI / 180));
            }
        } else if (entity.shouldPointArmsWhileCasting() && entity.isCasting()) {
            this.transformStack.pushRotation(leftArm, leftArm.getRotX() - entity.getXRot() * ((float)Math.PI / 180), leftArm.getRotY(), leftArm.getRotZ());
            this.transformStack.pushRotation(rightArm, rightArm.getRotX() - entity.getXRot() * ((float)Math.PI / 180), rightArm.getRotY(), rightArm.getRotZ());
        }
        this.transformStack.popStack();
    }

    protected void bobBone(GeoBone bone, int offset, float multiplier) {
        float z = multiplier * (Mth.cos((float)((float)offset * 0.09f)) * 0.05f + 0.05f);
        float x = multiplier * Mth.sin((float)((float)offset * 0.067f)) * 0.05f;
        this.transformStack.pushRotation(bone, x, 0.0f, z);
    }
}

