/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.datagen;

import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class IronRecipeProvider
extends RecipeProvider {
    public IronRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.quadRingSalvageRecipe(recipeOutput, ItemRegistry.FIREWARD_RING.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CINDER_ESSENCE.get()}));
        this.simpleRingSalvageRecipe(recipeOutput, ItemRegistry.FROSTWARD_RING.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ICE_CRYSTAL.get()}));
        this.simpleRingSalvageRecipe(recipeOutput, ItemRegistry.POISONWARD_RING.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.NATURE_RUNE.get()}));
        this.quadRingSalvageRecipe(recipeOutput, ItemRegistry.COOLDOWN_RING.get(), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER));
        this.simpleRingSalvageRecipe(recipeOutput, ItemRegistry.CAST_TIME_RING.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD}));
        this.simpleNecklaceSalvageRecipe(recipeOutput, ItemRegistry.HEAVY_CHAIN.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHAIN}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHAIN}));
        this.simpleRingSalvageRecipe(recipeOutput, ItemRegistry.EMERALD_STONEPLATE_RING.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.EXPERIENCE_BOTTLE}));
        this.simpleNecklaceSalvageRecipe(recipeOutput, ItemRegistry.CONJURERS_TALISMAN.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.SKELETON_SKULL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING}));
        this.simpleNecklaceSalvageRecipe(recipeOutput, ItemRegistry.CONCENTRATION_AMULET.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_INGOT.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHAIN}));
        this.simpleRingSalvageRecipe(recipeOutput, ItemRegistry.AFFINITY_RING.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.BUCKET}));
        this.simpleRingSalvageRecipe(recipeOutput, ItemRegistry.EXPULSION_RING.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.WIND_CHARGE}));
        this.simpleRingSalvageRecipe(recipeOutput, ItemRegistry.VISIBILITY_RING.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPYGLASS}));
    }

    protected void simpleRingSalvageRecipe(RecipeOutput output, Item result, Ingredient modifier) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('M'), modifier).define(Character.valueOf('X'), (ItemLike)ItemRegistry.MITHRIL_SCRAP.get()).pattern("M ").pattern(" X").unlockedBy("mithril_scrap", IronRecipeProvider.has((ItemLike)((ItemLike)ItemRegistry.MITHRIL_SCRAP.get()))).save(output);
    }

    protected void simpleNecklaceSalvageRecipe(RecipeOutput output, Item result, Ingredient modifier, Ingredient strap) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('M'), modifier).define(Character.valueOf('X'), (ItemLike)ItemRegistry.MITHRIL_SCRAP.get()).define(Character.valueOf('S'), strap).pattern(" S ").pattern("SXS").pattern(" M ").unlockedBy("mithril_scrap", IronRecipeProvider.has((ItemLike)((ItemLike)ItemRegistry.MITHRIL_SCRAP.get()))).save(output);
    }

    protected void quadRingSalvageRecipe(RecipeOutput output, Item result, Ingredient modifier) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('M'), modifier).define(Character.valueOf('X'), (ItemLike)ItemRegistry.MITHRIL_SCRAP.get()).pattern(" M ").pattern("MXM").pattern(" M ").unlockedBy("mithril_scrap", IronRecipeProvider.has((ItemLike)((ItemLike)ItemRegistry.MITHRIL_SCRAP.get()))).save(output);
    }
}

