/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.compat.tetra;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.compat.tetra.ITetraProxy;
import io.redspace.ironsspellbooks.compat.tetra.StatGetterPercentAttribute;
import io.redspace.ironsspellbooks.compat.tetra.effects.FreezeTetraEffect;
import io.redspace.ironsspellbooks.compat.tetra.effects.ManaSiphonTetraEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterPercentage;
import se.mickelus.tetra.items.modular.impl.ModularBladedItem;

public class TetraActualImpl
implements ITetraProxy {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        FreezeTetraEffect.addGuiBars();
        ManaSiphonTetraEffect.addGuiBars();
        TetraActualImpl.createPercentAttributeBar((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get(), "cooldown_reduction");
        TetraActualImpl.createPercentAttributeBar((Attribute)AttributeRegistry.FIRE_SPELL_POWER.get(), "fire_spell_power");
        TetraActualImpl.createPercentAttributeBar((Attribute)AttributeRegistry.ICE_SPELL_POWER.get(), "ice_spell_power");
        TetraActualImpl.createPercentAttributeBar((Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get(), "lightning_spell_power");
        TetraActualImpl.createPercentAttributeBar((Attribute)AttributeRegistry.HOLY_SPELL_POWER.get(), "holy_spell_power");
        TetraActualImpl.createPercentAttributeBar((Attribute)AttributeRegistry.ENDER_SPELL_POWER.get(), "ender_spell_power");
        TetraActualImpl.createPercentAttributeBar((Attribute)AttributeRegistry.BLOOD_SPELL_POWER.get(), "blood_spell_power");
        TetraActualImpl.createPercentAttributeBar((Attribute)AttributeRegistry.EVOCATION_SPELL_POWER.get(), "evocation_spell_power");
        TetraActualImpl.createPercentAttributeBar((Attribute)AttributeRegistry.NATURE_SPELL_POWER.get(), "poison_spell_power");
        TetraActualImpl.createPercentAttributeBar((Attribute)AttributeRegistry.SPELL_RESIST.get(), "spell_resist");
    }

    @Override
    public boolean canImbue(ItemStack itemStack) {
        return itemStack.getItem() instanceof ModularBladedItem;
    }

    @Override
    public void handleLivingAttackEvent(LivingDamageEvent.Post event) {
        if (!event.getEntity().level.isClientSide) {
            FreezeTetraEffect.handleLivingAttackEvent(event);
            ManaSiphonTetraEffect.handleLivingAttackEvent(event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void createPercentAttributeBar(Attribute attribute, String languageKey) {
        StatGetterPercentAttribute statGetter = new StatGetterPercentAttribute(attribute);
        GuiStatBar statBar = new GuiStatBar(0, 0, 59, attribute.getDescriptionId(), 0.0, 100.0, false, (IStatGetter)statGetter, LabelGetterBasic.percentageLabel, (ITooltipGetter)new TooltipGetterPercentage("irons_spellbooks.tetra_bar." + languageKey + ".tooltip", (IStatGetter)statGetter));
    }
}

